/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.staaaaaaaaaaaack.mixin;

import javax.annotation.ParametersAreNonnullByDefault;
import me.frankv.staaaaaaaaaaaack.Staaaaaaaaaaaack;
import me.frankv.staaaaaaaaaaaack.StxckUtil;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyArg;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@ParametersAreNonnullByDefault
@Mixin(value={ItemEntity.class})
public abstract class ItemEntityMixin
extends Entity {
    @Unique
    private static final EntityDataAccessor<Integer> STXCK_DATA_EXTRA_ITEM_COUNT = SynchedEntityData.m_135353_(ItemEntityMixin.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    @Unique
    private boolean discardedTick = false;

    public ItemEntityMixin(EntityType<?> entityType, Level level) {
        super(entityType, level);
    }

    @Inject(method={"<init>(Lnet/minecraft/world/entity/item/ItemEntity;)V"}, at={@At(value="RETURN")})
    private void constructorSetExtraCountInject(ItemEntity itemEntity, CallbackInfo ci) {
        StxckUtil.setExtraItemCount(this.getThis(), StxckUtil.getExtraItemCount(itemEntity));
    }

    @Inject(method={"<init>(Lnet/minecraft/world/level/Level;DDDLnet/minecraft/world/item/ItemStack;DDD)V"}, at={@At(value="RETURN")})
    private void constructorSetExtraCountInject(CallbackInfo ci) {
        StxckUtil.setExtraItemCount(this.getThis(), 0);
    }

    @Inject(method={"defineSynchedData"}, at={@At(value="RETURN")})
    private void defineSynchedDataForExtraItemCount(CallbackInfo ci) {
        this.getThis().m_20088_().m_135372_(STXCK_DATA_EXTRA_ITEM_COUNT, (Object)0);
    }

    @Inject(method={"tick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/Entity;tick()V", shift=At.Shift.AFTER)})
    private void tickInject(CallbackInfo ci) {
        this.discardedTick = false;
        StxckUtil.refillItemStack(this.getThis());
    }

    @Inject(method={"isMergable"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceIsMergable(CallbackInfoReturnable<Boolean> cir) {
        ItemEntity self = this.getThis();
        ItemStack itemStack = self.m_32055_();
        if (StxckUtil.isBlackListItem(itemStack) || StxckUtil.getExtraItemCount(self) >= Staaaaaaaaaaaack.commonConfig.getMaxSize()) {
            return;
        }
        cir.setReturnValue((Object)StxckUtil.isMergable(this.getThis()));
    }

    @Inject(method={"tryToMerge"}, at={@At(value="HEAD")}, cancellable=true)
    private void replaceTryToMerge(ItemEntity itemEntity1, CallbackInfo ci) {
        ItemEntity self = this.getThis();
        if (StxckUtil.isBlackListItem(self.m_32055_())) {
            return;
        }
        StxckUtil.tryToMerge(self, itemEntity1);
        ci.cancel();
    }

    @ModifyArg(method={"mergeWithNeighbours"}, at=@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;getEntitiesOfClass(Ljava/lang/Class;Lnet/minecraft/world/phys/AABB;Ljava/util/function/Predicate;)Ljava/util/List;"), index=1)
    private AABB mergeWithNeighbours(AABB uwu) {
        double h = Staaaaaaaaaaaack.commonConfig.getMaxMergeDistanceHorizontal();
        double v = Staaaaaaaaaaaack.commonConfig.getMaxMergeDistanceVertical();
        return this.getThis().m_20191_().m_82377_(h, v, h);
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/item/ItemStack;isEmpty()Z")})
    private void saveExtraItemCount(CompoundTag compoundTag, CallbackInfo ci) {
        int extraCount = StxckUtil.getExtraItemCount(this.getThis());
        if (extraCount > 0) {
            compoundTag.m_128405_("StxckExtraItemCount", extraCount);
        }
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="INVOKE", target="Lnet/minecraft/nbt/CompoundTag;getCompound(Ljava/lang/String;)Lnet/minecraft/nbt/CompoundTag;")})
    private void readExtraItemCount(CompoundTag compoundTag, CallbackInfo ci) {
        if (compoundTag.m_128441_("StxckExtraItemCount")) {
            StxckUtil.setExtraItemCount(this.getThis(), compoundTag.m_128451_("StxckExtraItemCount"));
        }
    }

    @Inject(method={"setItem"}, at={@At(value="HEAD")}, cancellable=true)
    private void handleSetEmpty(ItemStack item, CallbackInfo ci) {
        if (this.discardedTick) {
            ci.cancel();
            return;
        }
        if (item != ItemStack.f_41583_ && !item.m_150930_(Items.f_41852_)) {
            return;
        }
        ItemEntity self = this.getThis();
        if (StxckUtil.getExtraItemCount(self) <= 0) {
            return;
        }
        ItemStack copied = self.m_32055_().m_41777_();
        if (!copied.m_41619_()) {
            self.m_32045_(copied);
            copied.m_41764_(0);
        }
        ci.cancel();
    }

    @Inject(method={"playerTouch"}, at={@At(value="RETURN")})
    private void syncItemOnPickup(Player player, CallbackInfo ci) {
        ItemEntity self = this.getThis();
        ItemStack item = self.m_32055_();
        if (!item.m_41619_()) {
            self.m_32045_(item.m_41777_());
        }
    }

    public void m_142687_(Entity.RemovalReason reason) {
        if (StxckUtil.tryRefillItemStackOnEntityRemove((Entity)this.getThis(), reason)) {
            this.discardedTick = true;
            this.m_146912_();
            return;
        }
        super.m_142687_(reason);
    }

    private ItemEntity getThis() {
        return (ItemEntity)this;
    }

    static {
        StxckUtil.setDataExtraItemCount(STXCK_DATA_EXTRA_ITEM_COUNT);
    }
}

