/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.staaaaaaaaaaaack.config;

import java.util.ArrayList;
import java.util.List;
import me.frankv.staaaaaaaaaaaack.config.StxckCommonConfig;
import net.minecraftforge.common.ForgeConfigSpec;

public class StxckForgeCommonConfig
implements StxckCommonConfig {
    private final ForgeConfigSpec.DoubleValue maxMergeDistanceHorizontal;
    private final ForgeConfigSpec.DoubleValue maxMergeDistanceVertical;
    private final ForgeConfigSpec.IntValue maxSize;
    private final ForgeConfigSpec.BooleanValue enableForUnstackableItem;
    private final ForgeConfigSpec.ConfigValue<List<? extends String>> itemBlackList;

    public StxckForgeCommonConfig(ForgeConfigSpec.Builder builder) {
        builder.push("Item merge settings");
        this.maxMergeDistanceHorizontal = builder.comment("The maximum horizontal block distance over which dropped items attempt to merge with each other.").comment("Default: 1.25, Minecraft default: 0.5").defineInRange("maxMergeDistanceHorizontal", 1.25, 0.5, 10.0);
        this.maxMergeDistanceVertical = builder.comment("The maximum vertical block distance over which dropped items attempt to merge with each other.").comment("Default: 0.0, Minecraft default: 0.0").defineInRange("maxMergeDistanceVertical", 0.0, 0.0, 10.0);
        this.maxSize = builder.comment("The maximum number of extra items that an item entity can hold.").comment(String.format("Default: %d", Integer.MAX_VALUE)).defineInRange("maxSize", Integer.MAX_VALUE, 1, Integer.MAX_VALUE);
        this.enableForUnstackableItem = builder.comment("Enable for merging non-stackable item.").comment("Should be used with caution while playing with other mods.").comment("Default: false").define("enableForUnstackableItem", false);
        this.itemBlackList = builder.comment("The list of items that should not exceed their original max stack size.").comment("You can achieve the same feature by using the item tag \"#staaaaaaaaaaaack:blacklist\" as well.").comment("e.g., [\"minecraft:diamond_block\", \"minecraft:coal\"]").defineList("itemBlackList", ArrayList::new, o -> o instanceof String);
        builder.pop();
    }

    @Override
    public double getMaxMergeDistanceHorizontal() {
        return (Double)this.maxMergeDistanceHorizontal.get();
    }

    @Override
    public double getMaxMergeDistanceVertical() {
        return (Double)this.maxMergeDistanceVertical.get();
    }

    @Override
    public int getMaxSize() {
        return (Integer)this.maxSize.get();
    }

    @Override
    public boolean isEnableForUnstackableItem() {
        return (Boolean)this.enableForUnstackableItem.get();
    }

    @Override
    public List<? extends String> getItemBlackList() {
        return (List)this.itemBlackList.get();
    }
}

