/*
 * Decompiled with CFR 0.152.
 */
package me.frankv.staaaaaaaaaaaack;

import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import me.frankv.staaaaaaaaaaaack.Staaaaaaaaaaaack;
import me.frankv.staaaaaaaaaaaack.config.StxckClientConfig;
import me.frankv.staaaaaaaaaaaack.mixin.ItemEntityAccessor;
import me.frankv.staaaaaaaaaaaack.mixin.ItemStackAccessor;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public class StxckUtil {
    public static final String EXTRA_ITEM_COUNT_TAG = "StxckExtraItemCount";
    private static EntityDataAccessor<Integer> DATA_EXTRA_ITEM_COUNT;
    public static BiPredicate<ItemStack, ItemStack> areMergableReplacementPredicate;

    public static void setDataExtraItemCount(EntityDataAccessor<Integer> entityDataAccessor) {
        if (DATA_EXTRA_ITEM_COUNT != null) {
            return;
        }
        DATA_EXTRA_ITEM_COUNT = entityDataAccessor;
    }

    public static void refillItemStack(ItemEntity entity) {
        int extraItemCount = StxckUtil.getExtraItemCount(entity);
        if (extraItemCount <= 0) {
            return;
        }
        ItemStack stack = entity.m_32055_();
        Optional.ofNullable(((ItemStackAccessor)stack).accessItem()).map(Item::m_41459_).ifPresent(maxSize -> {
            if (stack.m_41613_() == maxSize.intValue()) {
                return;
            }
            int x = maxSize - stack.m_41613_();
            int refillCount = Math.min(x, extraItemCount);
            stack.m_41769_(refillCount);
            StxckUtil.setExtraItemCount(entity, extraItemCount - refillCount);
            entity.m_32045_(stack.m_41777_());
        });
    }

    public static boolean areMergable(ItemEntity itemEntity, ItemEntity itemEntity1) {
        int maxExtraSize = Staaaaaaaaaaaack.commonConfig.getMaxSize();
        if (maxExtraSize - StxckUtil.getExtraItemCount(itemEntity) < StxckUtil.getTotalCount(itemEntity1) && maxExtraSize - StxckUtil.getExtraItemCount(itemEntity1) < StxckUtil.getTotalCount(itemEntity)) {
            return false;
        }
        ItemStack itemStack = itemEntity.m_32055_();
        ItemStack itemStack1 = itemEntity1.m_32055_();
        if (areMergableReplacementPredicate != null) {
            return areMergableReplacementPredicate.test(itemStack, itemStack1);
        }
        if (!itemStack1.m_150930_(itemStack.m_41720_())) {
            return false;
        }
        if (itemStack1.m_41782_() ^ itemStack.m_41782_()) {
            return false;
        }
        return !itemStack1.m_41782_() || Objects.equals(itemStack1.m_41783_(), itemStack.m_41783_());
    }

    public static void grow(ItemEntity entity, int count) {
        StxckUtil.setExtraItemCount(entity, StxckUtil.getExtraItemCount(entity) + count);
        StxckUtil.refillItemStack(entity);
    }

    public static boolean isMergable(ItemEntity entity) {
        ItemEntityAccessor accessor = (ItemEntityAccessor)entity;
        int pickupDelay = accessor.getPickupDelay();
        int age = accessor.getAge();
        return entity.m_6084_() && pickupDelay != Short.MAX_VALUE && age != Short.MIN_VALUE && age < 6000;
    }

    public static Supplier<Optional<String>> getOverlayTextSupplier(ItemEntity entity) {
        boolean alwaysShowItemCount = Staaaaaaaaaaaack.clientConfig.isAlwaysShowItemCount();
        return switch (Staaaaaaaaaaaack.clientConfig.getOverlayDisplayMode()) {
            default -> throw new IncompatibleClassChangeError();
            case StxckClientConfig.OverlayDisplayMode.ITEM_COUNT -> () -> StxckUtil.getTotalCountOverlayText(entity, alwaysShowItemCount);
            case StxckClientConfig.OverlayDisplayMode.STACK_COUNT -> () -> {
                int maxStackSize = entity.m_32055_().m_41741_();
                int stackCount = (int)Math.ceil((double)StxckUtil.getTotalCount(entity) / (double)maxStackSize);
                boolean show = stackCount > 1 || alwaysShowItemCount;
                return show ? Optional.of(String.format("%dx", stackCount)) : Optional.empty();
            };
        };
    }

    private static Optional<String> getTotalCountOverlayText(ItemEntity entity, boolean alwaysShowItemCount) {
        int total = StxckUtil.getTotalCount(entity);
        if (total >= 1000000000) {
            return Optional.of(String.format("%.3fB", Float.valueOf((float)total / 1.0E9f)));
        }
        if (total >= 1000000) {
            return Optional.of(String.format("%.2fM", Float.valueOf((float)total / 1000000.0f)));
        }
        if (total >= 10000) {
            return Optional.of(String.format("%.1fK", Float.valueOf((float)total / 1000.0f)));
        }
        if (alwaysShowItemCount || total > entity.m_32055_().m_41741_()) {
            return Optional.of(String.valueOf(total));
        }
        return Optional.empty();
    }

    public static int getTotalCount(ItemEntity entity) {
        return entity.m_32055_().m_41613_() + StxckUtil.getExtraItemCount(entity);
    }

    public static int getExtraItemCount(ItemEntity entity) {
        return (Integer)entity.m_20088_().m_135370_(DATA_EXTRA_ITEM_COUNT);
    }

    public static void setExtraItemCount(ItemEntity entity, int count) {
        entity.m_20088_().m_135381_(DATA_EXTRA_ITEM_COUNT, (Object)count);
    }

    public static boolean tryRefillItemStackOnEntityRemove(Entity entity, Entity.RemovalReason reason) {
        if (!entity.m_6095_().equals(EntityType.f_20461_) || !reason.equals((Object)Entity.RemovalReason.DISCARDED)) {
            return false;
        }
        ItemEntity itemEntity = (ItemEntity)entity;
        if (StxckUtil.getExtraItemCount(itemEntity) <= 0) {
            return false;
        }
        ItemStack copied = itemEntity.m_32055_().m_41777_();
        itemEntity.m_32045_(copied);
        copied.m_41764_(0);
        StxckUtil.refillItemStack(itemEntity);
        return true;
    }

    public static void tryToMerge(ItemEntity itemEntity, ItemEntity itemEntity1) {
        StxckUtil.tryToMerge(itemEntity, itemEntity1, false);
    }

    public static void tryToMerge(ItemEntity itemEntity, ItemEntity itemEntity1, boolean mergeToExisted) {
        if (Objects.equals(itemEntity.m_19749_(), itemEntity1.m_19749_()) && StxckUtil.areMergable(itemEntity, itemEntity1)) {
            if (mergeToExisted || StxckUtil.getTotalCount(itemEntity1) < StxckUtil.getTotalCount(itemEntity)) {
                StxckUtil.merge(itemEntity, itemEntity1);
            } else {
                StxckUtil.merge(itemEntity1, itemEntity);
            }
        }
    }

    public static void merge(ItemEntity consumer, ItemEntity supplier) {
        ItemEntityAccessor consumerAccessor = (ItemEntityAccessor)consumer;
        ItemEntityAccessor supplierAccessor = (ItemEntityAccessor)supplier;
        consumerAccessor.setPickupDelay(Math.max(consumerAccessor.getPickupDelay(), supplierAccessor.getPickupDelay()));
        consumerAccessor.setAge(Math.min(consumerAccessor.getAge(), supplierAccessor.getAge()));
        StxckUtil.grow(consumer, StxckUtil.getTotalCount(supplier));
        StxckUtil.setExtraItemCount(supplier, 0);
        supplier.m_32045_(ItemStack.f_41583_);
        supplier.m_146870_();
    }

    public static boolean isBlackListItem(ItemStack itemStack) {
        if (!Staaaaaaaaaaaack.commonConfig.isEnableForUnstackableItem() && itemStack.m_41741_() == 1) {
            return true;
        }
        return itemStack.m_204117_(Staaaaaaaaaaaack.BLACK_LIST_TAG) || Staaaaaaaaaaaack.getItemBlackList().contains(itemStack.m_41720_());
    }
}

