/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.farmersassortment.data.client;

import com.tiomadre.farmersassortment.core.block.state.TerracottaCookingPotColor;
import com.tiomadre.farmersassortment.core.registry.FABlocks;
import com.tiomadre.farmersassortment.core.registry.FAItems;
import java.util.Objects;
import net.minecraft.data.PackOutput;
import net.minecraft.world.level.block.Block;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;

public class FAItemModels
extends ItemModelProvider {
    public FAItemModels(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "farmersassortment", existingFileHelper);
    }

    protected void registerModels() {
        this.handheldItem(FAItems.AMETHYST_KNIFE);
        this.handheldItem(FAItems.QUARTZ_KNIFE);
        this.block(FABlocks.COPPER_COOKING_POT);
        this.block(FABlocks.GOLDEN_COOKING_POT);
        this.block(FABlocks.ALABASTER_COOKING_POT);
        this.terracottaCookingPot();
        this.block(FABlocks.ALABASTER_STOVE);
        FABlocks.cuttingBoards().forEach(this::block);
        FABlocks.butcherBlockCabinets().forEach(this::block);
    }

    private void handheldItem(RegistryObject<?> item) {
        String name = Objects.requireNonNull(item.getId()).m_135815_();
        ((ItemModelBuilder)this.withExistingParent(name, this.mcLoc("item/handheld"))).texture("layer0", this.modLoc("item/" + name));
    }

    private void block(RegistryObject<? extends Block> block) {
        String name = Objects.requireNonNull(block.getId()).m_135815_();
        this.withExistingParent(name, this.modLoc("block/" + name));
    }

    private void terracottaCookingPot() {
        ItemModelBuilder builder = (ItemModelBuilder)this.withExistingParent("terracotta_cooking_pot", this.modLoc("block/terracotta_cooking_pot"));
        for (TerracottaCookingPotColor color : TerracottaCookingPotColor.values()) {
            if (color == TerracottaCookingPotColor.NONE) continue;
            builder.override().predicate(this.modLoc("color"), (float)color.ordinal()).model(this.getModelForTerracottaColor(color)).end();
        }
    }

    private ModelFile getModelForTerracottaColor(TerracottaCookingPotColor color) {
        return this.getExistingFile(this.modLoc("block/" + color.textureName()));
    }
}

