/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.farmersassortment.data.client;

import com.tiomadre.farmersassortment.core.block.ButcherBlockCabinetBlock;
import com.tiomadre.farmersassortment.core.block.TerracottaCookingPotBlock;
import com.tiomadre.farmersassortment.core.block.UniqueStoveBlock;
import com.tiomadre.farmersassortment.core.block.state.TerracottaCookingPotColor;
import com.tiomadre.farmersassortment.core.registry.FABlocks;
import com.tiomadre.farmersassortment.data.client.FABlockStateHelper;
import java.util.EnumMap;
import java.util.List;
import java.util.Objects;
import net.minecraft.core.Direction;
import net.minecraft.data.PackOutput;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.block.StoveBlock;
import vectorwing.farmersdelight.common.block.state.CookingPotSupport;

public class FABlockStates
extends BlockStateProvider {
    public FABlockStates(PackOutput output, ExistingFileHelper existingFileHelper) {
        super(output, "farmersassortment", existingFileHelper);
    }

    protected void registerStatesAndModels() {
        this.registerCabinets();
        this.registerCuttingBoards();
        this.registerCookingPots();
        this.registerStoves();
    }

    private void registerCabinets() {
        List<CabinetDefinition> cabinets = List.of(new CabinetDefinition(FABlocks.OAK_BUTCHER_BLOCK_CABINET, "oak", "minecraft:block/oak_planks", "block/oak_butcher_block_cabinet_top"), new CabinetDefinition(FABlocks.SPRUCE_BUTCHER_BLOCK_CABINET, "spruce", "minecraft:block/spruce_planks", "block/spruce_butcher_block_cabinet_top"), new CabinetDefinition(FABlocks.BIRCH_BUTCHER_BLOCK_CABINET, "birch", "minecraft:block/birch_planks", "block/birch_butcher_block_cabinet_top"), new CabinetDefinition(FABlocks.JUNGLE_BUTCHER_BLOCK_CABINET, "jungle", "minecraft:block/jungle_planks", "block/jungle_butcher_block_cabinet_top"), new CabinetDefinition(FABlocks.ACACIA_BUTCHER_BLOCK_CABINET, "acacia", "minecraft:block/acacia_planks", "block/acacia_butcher_block_cabinet_top"), new CabinetDefinition(FABlocks.DARK_OAK_BUTCHER_BLOCK_CABINET, "dark_oak", "minecraft:block/dark_oak_planks", "block/dark_oak_butcher_block_cabinet_top"), new CabinetDefinition(FABlocks.MANGROVE_BUTCHER_BLOCK_CABINET, "mangrove", "minecraft:block/mangrove_planks", "block/mangrove_butcher_block_cabinet_top"), new CabinetDefinition(FABlocks.CHERRY_BUTCHER_BLOCK_CABINET, "cherry", "minecraft:block/cherry_planks", "block/cherry_butcher_block_cabinet_top"), new CabinetDefinition(FABlocks.BAMBOO_BUTCHER_BLOCK_CABINET, "bamboo", "minecraft:block/bamboo_planks", "block/bamboo_butcher_block_cabinet_top"), new CabinetDefinition(FABlocks.CRIMSON_BUTCHER_BLOCK_CABINET, "crimson", "minecraft:block/crimson_planks", "block/crimson_butcher_block_cabinet_front_top"), new CabinetDefinition(FABlocks.WARPED_BUTCHER_BLOCK_CABINET, "warped", "minecraft:block/warped_planks", "block/warped_butcher_block_cabinet_top"));
        cabinets.forEach(cabinet -> this.registerButcherBlockCabinet(cabinet.block(), cabinet.woodType(), cabinet.bottomTexturePath(), this.modLoc(cabinet.topTexturePath())));
    }

    private void registerCuttingBoards() {
        List<RegistryObject<CuttingBoardBlock>> standardBoards = List.of(FABlocks.BIRCH_CUTTING_BOARD, FABlocks.JUNGLE_CUTTING_BOARD, FABlocks.DARK_OAK_CUTTING_BOARD, FABlocks.BAMBOO_CUTTING_BOARD, FABlocks.CRIMSON_CUTTING_BOARD, FABlocks.WARPED_CUTTING_BOARD, FABlocks.SPRUCE_CUTTING_BOARD, FABlocks.ACACIA_CUTTING_BOARD, FABlocks.MANGROVE_CUTTING_BOARD, FABlocks.CHERRY_CUTTING_BOARD);
        standardBoards.forEach(this::registerCuttingBoard);
    }

    private void registerCookingPots() {
        List<CookingPotDefinition> cookingPots = List.of(new CookingPotDefinition(FABlocks.COPPER_COOKING_POT, "copper", "block/copper_cooking_pot_bottom"), new CookingPotDefinition(FABlocks.GOLDEN_COOKING_POT, "golden", "block/golden_cooking_pot_bottom"), new CookingPotDefinition(FABlocks.ALABASTER_COOKING_POT, "alabaster", "block/alabaster_cooking_pot_bottom"));
        cookingPots.forEach(pot -> this.registerCookingPot(pot.block(), pot.materialName(), this.modLoc(pot.bottomTexturePath())));
        this.registerTerracottaCookingPot();
    }

    private void registerStoves() {
        RegistryObject<UniqueStoveBlock> stove = FABlocks.ALABASTER_STOVE;
        ModelBuilder offModel = this.models().orientableWithBottom(stove.getId().m_135815_(), this.modLoc("block/alabaster_stove_side"), this.modLoc("block/alabaster_stove_front"), this.modLoc("block/alabaster_stove_bottom"), this.modLoc("block/alabaster_stove_top"));
        ModelBuilder onModel = this.models().orientableWithBottom(stove.getId().m_135815_() + "_on", this.modLoc("block/alabaster_stove_side"), this.modLoc("block/alabaster_stove_on"), this.modLoc("block/alabaster_stove_bottom"), this.modLoc("block/alabaster_stove_top_on"));
        this.getVariantBuilder((Block)stove.get()).forAllStates(arg_0 -> FABlockStates.lambda$registerStoves$2((ModelFile)onModel, (ModelFile)offModel, arg_0));
    }

    private void registerTerracottaCookingPot() {
        RegistryObject<CookingPotBlock> block = FABlocks.TERRACOTTA_COOKING_POT;
        ResourceLocation handleTexture = this.modLoc("block/terracotta_cooking_pot_handle");
        EnumMap<TerracottaCookingPotColor, BlockModelBuilder> baseModels = new EnumMap<TerracottaCookingPotColor, BlockModelBuilder>(TerracottaCookingPotColor.class);
        EnumMap<TerracottaCookingPotColor, BlockModelBuilder> trayModels = new EnumMap<TerracottaCookingPotColor, BlockModelBuilder>(TerracottaCookingPotColor.class);
        EnumMap<TerracottaCookingPotColor, BlockModelBuilder> handleModels = new EnumMap<TerracottaCookingPotColor, BlockModelBuilder>(TerracottaCookingPotColor.class);
        for (TerracottaCookingPotColor color : TerracottaCookingPotColor.values()) {
            String suffix = color.m_7912_();
            Object modelBaseName = suffix.equals(TerracottaCookingPotColor.NONE.m_7912_()) ? "terracotta_cooking_pot" : "terracotta_cooking_pot_" + suffix;
            ResourceLocation sideTexture = color.sideTexture();
            ResourceLocation topTexture = color.topTexture();
            ResourceLocation bottomTexture = color.bottomTexture();
            ResourceLocation partsTexture = color.partsTexture();
            ResourceLocation trayTop = this.modLoc("block/cooking_pot_tray_top");
            ResourceLocation traySide = this.modLoc("block/cooking_pot_tray_side");
            baseModels.put(color, this.terracottaCookingPotModel((String)modelBaseName, sideTexture, topTexture, bottomTexture, partsTexture));
            trayModels.put(color, this.terracottaCookingPotTrayModel((String)modelBaseName + "_tray", sideTexture, topTexture, bottomTexture, partsTexture, trayTop, traySide));
            handleModels.put(color, this.terracottaCookingPotHandleModel((String)modelBaseName + "_handle", sideTexture, topTexture, bottomTexture, partsTexture, handleTexture));
        }
        this.getVariantBuilder((Block)block.get()).forAllStates(state -> {
            Direction direction = (Direction)state.m_61143_((Property)CookingPotBlock.FACING);
            CookingPotSupport support = (CookingPotSupport)state.m_61143_((Property)CookingPotBlock.SUPPORT);
            TerracottaCookingPotColor color = (TerracottaCookingPotColor)((Object)((Object)state.m_61143_(TerracottaCookingPotBlock.COLOR)));
            ModelFile model = switch (support) {
                case CookingPotSupport.TRAY -> (ModelFile)trayModels.get((Object)color);
                case CookingPotSupport.HANDLE -> (ModelFile)handleModels.get((Object)color);
                default -> (ModelFile)baseModels.get((Object)color);
            };
            return ConfiguredModel.builder().modelFile(model).rotationY((int)direction.m_122435_()).build();
        });
    }

    private void registerCuttingBoard(RegistryObject<CuttingBoardBlock> block) {
        String name = Objects.requireNonNull(block.getId()).m_135815_();
        ModelBuilder model = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("farmersdelight:block/cutting_board"))).texture("particle", this.modLoc("block/" + name))).texture("top", this.modLoc("block/" + name))).renderType("minecraft:cutout");
        FABlockStateHelper.horizontalFacingBlock(this, (Block)block.get(), (ModelFile)model);
    }

    private void registerButcherBlockCabinet(RegistryObject<? extends Block> block, String woodType, String bottomTexture, ResourceLocation topTexture) {
        String name = block.getId().m_135815_();
        ModelBuilder closed = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:block/orientable_with_bottom"))).texture("front", this.modLoc("block/" + woodType + "_butcher_block_cabinet_front"))).texture("side", this.modLoc("block/" + woodType + "_butcher_block_cabinet_side"))).texture("top", topTexture)).texture("bottom", bottomTexture);
        ModelBuilder open = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name + "_open")).parent((ModelFile)new ModelFile.UncheckedModelFile("minecraft:block/orientable_with_bottom"))).texture("front", this.modLoc("block/" + woodType + "_butcher_block_cabinet_front_open"))).texture("side", this.modLoc("block/" + woodType + "_butcher_block_cabinet_side"))).texture("top", topTexture)).texture("bottom", bottomTexture);
        this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> FABlockStates.lambda$registerButcherBlockCabinet$4((ModelFile)open, (ModelFile)closed, arg_0));
    }

    private void registerCookingPot(RegistryObject<CookingPotBlock> block, String materialName, ResourceLocation bottomTexture) {
        BlockModelBuilder pot = this.cookingPotModel(materialName, bottomTexture);
        BlockModelBuilder tray = this.cookingPotTrayModel(materialName, bottomTexture);
        BlockModelBuilder handle = this.cookingPotHandleModel(materialName, bottomTexture);
        this.getVariantBuilder((Block)block.get()).forAllStates(arg_0 -> FABlockStates.lambda$registerCookingPot$5((ModelFile)tray, (ModelFile)handle, (ModelFile)pot, arg_0));
    }

    private BlockModelBuilder cookingPotModel(String materialName, ResourceLocation bottomTexture) {
        BlockModelBuilder builder = this.baseCookingPotModel(materialName + "_cooking_pot", materialName, bottomTexture);
        this.addCoreCookingPotElements(builder);
        return builder;
    }

    private BlockModelBuilder cookingPotTrayModel(String materialName, ResourceLocation bottomTexture) {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.baseCookingPotModel(materialName + "_cooking_pot_tray", materialName, bottomTexture).texture("tray_top", this.modLoc("block/" + materialName + "_cooking_pot_tray_top"))).texture("tray_side", this.modLoc("block/" + materialName + "_cooking_pot_tray_side"));
        this.addCoreCookingPotElements(builder);
        this.addCookingPotTrayElements(builder);
        return builder;
    }

    private BlockModelBuilder cookingPotHandleModel(String materialName, ResourceLocation bottomTexture) {
        BlockModelBuilder builder = (BlockModelBuilder)this.baseCookingPotModel(materialName + "_cooking_pot_handle", materialName, bottomTexture).texture("handle", this.modLoc("block/" + materialName + "_cooking_pot_handle"));
        this.addCoreCookingPotElements(builder);
        this.addCookingPotHandleElements(builder);
        return builder;
    }

    private BlockModelBuilder baseCookingPotModel(String name, String materialName, ResourceLocation bottomTexture) {
        ResourceLocation sideTexture = this.modLoc("block/" + materialName + "_cooking_pot_side");
        ResourceLocation topTexture = this.modLoc("block/" + materialName + "_cooking_pot_top");
        ResourceLocation partsTexture = this.modLoc("block/" + materialName + "_cooking_pot_parts");
        return this.baseCookingPotModel(name, sideTexture, topTexture, bottomTexture, partsTexture);
    }

    private BlockModelBuilder terracottaCookingPotModel(String name, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation bottomTexture, ResourceLocation partsTexture) {
        BlockModelBuilder builder = this.baseCookingPotModel(name, sideTexture, topTexture, bottomTexture, partsTexture);
        this.addCoreCookingPotElements(builder);
        return builder;
    }

    private BlockModelBuilder terracottaCookingPotTrayModel(String name, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation bottomTexture, ResourceLocation partsTexture, ResourceLocation trayTop, ResourceLocation traySide) {
        BlockModelBuilder builder = (BlockModelBuilder)((BlockModelBuilder)this.baseCookingPotModel(name, sideTexture, topTexture, bottomTexture, partsTexture).texture("tray_top", trayTop)).texture("tray_side", traySide);
        this.addCoreCookingPotElements(builder);
        this.addCookingPotTrayElements(builder);
        return builder;
    }

    private BlockModelBuilder terracottaCookingPotHandleModel(String name, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation bottomTexture, ResourceLocation partsTexture, ResourceLocation handleTexture) {
        BlockModelBuilder builder = (BlockModelBuilder)this.baseCookingPotModel(name, sideTexture, topTexture, bottomTexture, partsTexture).texture("handle", handleTexture);
        this.addCoreCookingPotElements(builder);
        this.addCookingPotHandleElements(builder);
        return builder;
    }

    private BlockModelBuilder baseCookingPotModel(String name, ResourceLocation sideTexture, ResourceLocation topTexture, ResourceLocation bottomTexture, ResourceLocation partsTexture) {
        return (BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().getBuilder(name)).parent((ModelFile)new ModelFile.UncheckedModelFile("block/block"))).renderType("minecraft:cutout")).texture("particle", sideTexture)).texture("side", sideTexture)).texture("top", topTexture)).texture("parts", partsTexture)).texture("bottom", bottomTexture);
    }

    private void addCoreCookingPotElements(BlockModelBuilder builder) {
        builder.element().from(2.0f, 0.0f, 2.0f).to(14.0f, 10.0f, 14.0f).face(Direction.NORTH).uvs(2.0f, 6.0f, 14.0f, 16.0f).texture("#side").end().face(Direction.EAST).uvs(2.0f, 6.0f, 14.0f, 16.0f).texture("#side").end().face(Direction.SOUTH).uvs(2.0f, 6.0f, 14.0f, 16.0f).texture("#side").end().face(Direction.WEST).uvs(2.0f, 6.0f, 14.0f, 16.0f).texture("#side").end().face(Direction.UP).uvs(2.0f, 2.0f, 14.0f, 14.0f).texture("#top").end().face(Direction.DOWN).uvs(2.0f, 2.0f, 14.0f, 14.0f).texture("#bottom").cullface(Direction.DOWN).end().end();
        ModelBuilder.ElementBuilder spoon = builder.element().from(7.0f, 3.0f, 7.0f).to(9.0f, 15.0f, 9.0f);
        spoon.rotation().angle(-22.5f).axis(Direction.Axis.Z).origin(8.0f, 3.0f, 8.0f).end();
        spoon.face(Direction.NORTH).uvs(2.0f, 2.0f, 0.0f, 14.0f).texture("#parts").end().face(Direction.EAST).uvs(0.0f, 2.0f, 2.0f, 14.0f).texture("#parts").end().face(Direction.SOUTH).uvs(2.0f, 2.0f, 0.0f, 14.0f).texture("#parts").end().face(Direction.WEST).uvs(0.0f, 2.0f, 2.0f, 14.0f).texture("#parts").end().face(Direction.UP).uvs(0.0f, 0.0f, 2.0f, 2.0f).texture("#parts").end().face(Direction.DOWN).uvs(0.0f, 0.0f, 2.0f, 2.0f).texture("#parts").end().end();
        builder.element().from(14.0f, 7.0f, 5.0f).to(16.0f, 9.0f, 11.0f).face(Direction.NORTH).uvs(10.0f, 0.0f, 12.0f, 2.0f).texture("#parts").end().face(Direction.EAST).uvs(4.0f, 2.0f, 10.0f, 4.0f).texture("#parts").end().face(Direction.SOUTH).uvs(2.0f, 0.0f, 4.0f, 2.0f).texture("#parts").end().face(Direction.UP).uvs(4.0f, 0.0f, 10.0f, 2.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#parts").end().face(Direction.DOWN).uvs(4.0f, 2.0f, 10.0f, 4.0f).rotation(ModelBuilder.FaceRotation.CLOCKWISE_90).texture("#parts").end().end();
        builder.element().from(0.0f, 7.0f, 5.0f).to(2.0f, 9.0f, 11.0f).face(Direction.NORTH).uvs(2.0f, 0.0f, 4.0f, 2.0f).texture("#parts").end().face(Direction.SOUTH).uvs(10.0f, 0.0f, 12.0f, 2.0f).texture("#parts").end().face(Direction.WEST).uvs(4.0f, 2.0f, 10.0f, 4.0f).texture("#parts").end().face(Direction.UP).uvs(4.0f, 0.0f, 10.0f, 2.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#parts").end().face(Direction.DOWN).uvs(4.0f, 2.0f, 10.0f, 4.0f).rotation(ModelBuilder.FaceRotation.COUNTERCLOCKWISE_90).texture("#parts").end().end();
    }

    private void addCookingPotTrayElements(BlockModelBuilder builder) {
        builder.element().from(0.0f, -1.0f, 0.0f).to(16.0f, 0.0f, 16.0f).face(Direction.NORTH).uvs(0.0f, 0.0f, 16.0f, 1.0f).texture("#tray_side").end().face(Direction.EAST).uvs(0.0f, 0.0f, 16.0f, 1.0f).texture("#tray_side").end().face(Direction.SOUTH).uvs(0.0f, 0.0f, 16.0f, 1.0f).texture("#tray_side").end().face(Direction.WEST).uvs(0.0f, 0.0f, 16.0f, 1.0f).texture("#tray_side").end().face(Direction.UP).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#tray_top").end().face(Direction.DOWN).uvs(0.0f, 0.0f, 16.0f, 16.0f).texture("#tray_top").end().end();
        builder.element().from(15.0f, -16.0f, 15.0f).to(16.0f, -1.0f, 16.0f).face(Direction.NORTH).uvs(0.0f, 1.0f, 1.0f, 16.0f).texture("#tray_side").end().face(Direction.EAST).uvs(0.0f, 1.0f, 1.0f, 16.0f).texture("#tray_side").end().face(Direction.SOUTH).uvs(15.0f, 1.0f, 16.0f, 16.0f).texture("#tray_side").end().face(Direction.WEST).uvs(15.0f, 1.0f, 16.0f, 16.0f).texture("#tray_side").end().face(Direction.UP).uvs(0.0f, 0.0f, 0.5f, 0.5f).texture("#tray_side").end().face(Direction.DOWN).uvs(0.0f, 0.0f, 0.5f, 0.5f).texture("#tray_side").end().end();
        builder.element().from(0.0f, -16.0f, 15.0f).to(1.0f, -1.0f, 16.0f).face(Direction.NORTH).uvs(15.0f, 1.0f, 16.0f, 16.0f).texture("#tray_side").end().face(Direction.EAST).uvs(0.0f, 1.0f, 1.0f, 16.0f).texture("#tray_side").end().face(Direction.SOUTH).uvs(0.0f, 1.0f, 1.0f, 16.0f).texture("#tray_side").end().face(Direction.WEST).uvs(15.0f, 1.0f, 16.0f, 16.0f).texture("#tray_side").end().face(Direction.UP).uvs(0.0f, 0.0f, 0.5f, 0.5f).texture("#tray_side").end().face(Direction.DOWN).uvs(0.0f, 0.0f, 0.5f, 0.5f).texture("#tray_side").end().end();
        builder.element().from(15.0f, -16.0f, 0.0f).to(16.0f, -1.0f, 1.0f).face(Direction.NORTH).uvs(0.0f, 1.0f, 1.0f, 16.0f).texture("#tray_side").end().face(Direction.EAST).uvs(15.0f, 1.0f, 16.0f, 16.0f).texture("#tray_side").end().face(Direction.SOUTH).uvs(15.0f, 1.0f, 16.0f, 16.0f).texture("#tray_side").end().face(Direction.WEST).uvs(0.0f, 1.0f, 1.0f, 16.0f).texture("#tray_side").end().face(Direction.UP).uvs(0.0f, 0.0f, 0.5f, 0.5f).texture("#tray_side").end().face(Direction.DOWN).uvs(0.0f, 0.0f, 0.5f, 0.5f).texture("#tray_side").end().end();
        builder.element().from(0.0f, -16.0f, 0.0f).to(1.0f, -1.0f, 1.0f).face(Direction.NORTH).uvs(15.0f, 1.0f, 16.0f, 16.0f).texture("#tray_side").end().face(Direction.EAST).uvs(15.0f, 1.0f, 16.0f, 16.0f).texture("#tray_side").end().face(Direction.SOUTH).uvs(0.0f, 1.0f, 1.0f, 16.0f).texture("#tray_side").end().face(Direction.WEST).uvs(0.0f, 1.0f, 1.0f, 16.0f).texture("#tray_side").end().face(Direction.UP).uvs(0.0f, 0.0f, 0.5f, 0.5f).texture("#tray_side").end().face(Direction.DOWN).uvs(0.0f, 0.0f, 0.5f, 0.5f).texture("#tray_side").end().end();
    }

    private void addCookingPotHandleElements(BlockModelBuilder builder) {
        builder.element().from(1.0f, 8.0f, 8.0f).to(15.0f, 16.0f, 8.0f).face(Direction.NORTH).uvs(1.0f, 8.0f, 15.0f, 16.0f).texture("#handle").end().face(Direction.SOUTH).uvs(1.0f, 8.0f, 15.0f, 16.0f).texture("#handle").end().end();
        builder.element().from(15.0f, 8.0f, 7.0f).to(15.0f, 16.0f, 9.0f).face(Direction.EAST).uvs(2.0f, 0.0f, 0.0f, 8.0f).texture("#handle").end().face(Direction.WEST).uvs(0.0f, 0.0f, 2.0f, 8.0f).texture("#handle").end().end();
        builder.element().from(1.0f, 8.0f, 7.0f).to(1.0f, 16.0f, 9.0f).face(Direction.EAST).uvs(2.0f, 0.0f, 0.0f, 8.0f).texture("#handle").end().face(Direction.WEST).uvs(0.0f, 0.0f, 2.0f, 8.0f).texture("#handle").end().end();
        builder.element().from(1.0f, 15.999f, 7.0f).to(15.0f, 15.999f, 9.0f).face(Direction.UP).uvs(2.0f, 0.0f, 16.0f, 2.0f).texture("#handle").end().face(Direction.DOWN).uvs(2.0f, 0.0f, 16.0f, 2.0f).texture("#handle").end().end();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerCookingPot$5(ModelFile tray, ModelFile handle, ModelFile pot, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)CookingPotBlock.FACING);
        CookingPotSupport support = (CookingPotSupport)state.m_61143_((Property)CookingPotBlock.SUPPORT);
        ModelFile model = switch (support) {
            case CookingPotSupport.TRAY -> tray;
            case CookingPotSupport.HANDLE -> handle;
            default -> pot;
        };
        return ConfiguredModel.builder().modelFile(model).rotationY((int)direction.m_122435_() % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerButcherBlockCabinet$4(ModelFile open, ModelFile closed, BlockState state) {
        Direction direction = (Direction)state.m_61143_((Property)ButcherBlockCabinetBlock.FACING);
        boolean openState = (Boolean)state.m_61143_((Property)ButcherBlockCabinetBlock.OPEN);
        ModelFile model = openState ? open : closed;
        return ConfiguredModel.builder().modelFile(model).rotationY((int)direction.m_122435_() % 360).build();
    }

    private static /* synthetic */ ConfiguredModel[] lambda$registerStoves$2(ModelFile onModel, ModelFile offModel, BlockState state) {
        return ConfiguredModel.builder().modelFile((Boolean)state.m_61143_((Property)StoveBlock.LIT) != false ? onModel : offModel).rotationY(((int)((Direction)state.m_61143_((Property)StoveBlock.FACING)).m_122435_() + 180) % 360).build();
    }

    private record CabinetDefinition(RegistryObject<? extends Block> block, String woodType, String bottomTexturePath, String topTexturePath) {
    }

    private record CookingPotDefinition(RegistryObject<CookingPotBlock> block, String materialName, String bottomTexturePath) {
    }
}

