/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.farmersassortment.core.registry;

import com.teamabnormals.blueprint.core.util.registry.BlockSubRegistryHelper;
import com.tiomadre.farmersassortment.core.FarmersAssortment;
import com.tiomadre.farmersassortment.core.block.ButcherBlockCabinetBlock;
import com.tiomadre.farmersassortment.core.block.TerracottaCookingPotBlock;
import com.tiomadre.farmersassortment.core.block.UniqueStoveBlock;
import com.tiomadre.farmersassortment.core.item.TerracottaCookingPotItem;
import com.tiomadre.farmersassortment.core.mixin.BlockEntityTypeAccessor;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Stream;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.material.MapColor;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.RegistryObject;
import vectorwing.farmersdelight.common.block.CookingPotBlock;
import vectorwing.farmersdelight.common.block.CuttingBoardBlock;
import vectorwing.farmersdelight.common.item.CookingPotItem;
import vectorwing.farmersdelight.common.registry.ModBlockEntityTypes;

public final class FABlocks {
    public static final BlockSubRegistryHelper BLOCKS = (BlockSubRegistryHelper)FarmersAssortment.REGISTRY_HELPER.getBlockSubHelper();
    public static final RegistryObject<ButcherBlockCabinetBlock> OAK_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("oak", Blocks.f_50705_);
    public static final RegistryObject<ButcherBlockCabinetBlock> SPRUCE_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("spruce", Blocks.f_50741_);
    public static final RegistryObject<ButcherBlockCabinetBlock> BIRCH_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("birch", Blocks.f_50742_);
    public static final RegistryObject<ButcherBlockCabinetBlock> JUNGLE_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("jungle", Blocks.f_50743_);
    public static final RegistryObject<ButcherBlockCabinetBlock> ACACIA_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("acacia", Blocks.f_50744_);
    public static final RegistryObject<ButcherBlockCabinetBlock> DARK_OAK_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("dark_oak", Blocks.f_50745_);
    public static final RegistryObject<ButcherBlockCabinetBlock> MANGROVE_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("mangrove", Blocks.f_220865_);
    public static final RegistryObject<ButcherBlockCabinetBlock> CHERRY_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("cherry", Blocks.f_271304_);
    public static final RegistryObject<ButcherBlockCabinetBlock> BAMBOO_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("bamboo", Blocks.f_244477_);
    public static final RegistryObject<ButcherBlockCabinetBlock> CRIMSON_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("crimson", Blocks.f_50655_);
    public static final RegistryObject<ButcherBlockCabinetBlock> WARPED_BUTCHER_BLOCK_CABINET = FABlocks.registerButcherBlockCabinet("warped", Blocks.f_50656_);
    public static final RegistryObject<CuttingBoardBlock> SPRUCE_CUTTING_BOARD = FABlocks.registerCuttingBoard("spruce", Blocks.f_50741_);
    public static final RegistryObject<CuttingBoardBlock> BIRCH_CUTTING_BOARD = FABlocks.registerCuttingBoard("birch", Blocks.f_50742_);
    public static final RegistryObject<CuttingBoardBlock> JUNGLE_CUTTING_BOARD = FABlocks.registerCuttingBoard("jungle", Blocks.f_50743_);
    public static final RegistryObject<CuttingBoardBlock> ACACIA_CUTTING_BOARD = FABlocks.registerCuttingBoard("acacia", Blocks.f_50744_);
    public static final RegistryObject<CuttingBoardBlock> DARK_OAK_CUTTING_BOARD = FABlocks.registerCuttingBoard("dark_oak", Blocks.f_50745_);
    public static final RegistryObject<CuttingBoardBlock> MANGROVE_CUTTING_BOARD = FABlocks.registerCuttingBoard("mangrove", Blocks.f_220865_);
    public static final RegistryObject<CuttingBoardBlock> CHERRY_CUTTING_BOARD = FABlocks.registerCuttingBoard("cherry", Blocks.f_271304_);
    public static final RegistryObject<CuttingBoardBlock> BAMBOO_CUTTING_BOARD = FABlocks.registerCuttingBoard("bamboo", Blocks.f_244477_);
    public static final RegistryObject<CuttingBoardBlock> CRIMSON_CUTTING_BOARD = FABlocks.registerCuttingBoard("crimson", Blocks.f_50655_);
    public static final RegistryObject<CuttingBoardBlock> WARPED_CUTTING_BOARD = FABlocks.registerCuttingBoard("warped", Blocks.f_50656_);
    private static final ResourceLocation COPPER_COOKING_POT_ID = new ResourceLocation("farmersassortment", "copper_cooking_pot");
    private static final ResourceLocation GOLDEN_COOKING_POT_ID = new ResourceLocation("farmersassortment", "golden_cooking_pot");
    private static final ResourceLocation ALABASTER_COOKING_POT_ID = new ResourceLocation("farmersassortment", "alabaster_cooking_pot");
    private static final ResourceLocation TERRACOTTA_COOKING_POT_ID = new ResourceLocation("farmersassortment", "terracotta_cooking_pot");
    public static final RegistryObject<CookingPotBlock> COPPER_COOKING_POT = FABlocks.registerCookingPot("copper_cooking_pot", MapColor.f_283906_, SoundType.f_154663_, COPPER_COOKING_POT_ID);
    public static final RegistryObject<CookingPotBlock> GOLDEN_COOKING_POT = FABlocks.registerCookingPot("golden_cooking_pot", MapColor.f_283757_, SoundType.f_56762_, GOLDEN_COOKING_POT_ID);
    public static final RegistryObject<CookingPotBlock> ALABASTER_COOKING_POT = FABlocks.registerCookingPot("alabaster_cooking_pot", MapColor.f_283919_, SoundType.f_154660_, ALABASTER_COOKING_POT_ID);
    public static final RegistryObject<CookingPotBlock> TERRACOTTA_COOKING_POT = FABlocks.registerTerracottaCookingPot();
    public static final RegistryObject<UniqueStoveBlock> ALABASTER_STOVE = BLOCKS.createBlock("alabaster_stove", () -> new UniqueStoveBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50094_)), new Item.Properties());

    public static Stream<RegistryObject<CuttingBoardBlock>> cuttingBoards() {
        return Stream.of(SPRUCE_CUTTING_BOARD, BIRCH_CUTTING_BOARD, JUNGLE_CUTTING_BOARD, ACACIA_CUTTING_BOARD, DARK_OAK_CUTTING_BOARD, MANGROVE_CUTTING_BOARD, CHERRY_CUTTING_BOARD, BAMBOO_CUTTING_BOARD, CRIMSON_CUTTING_BOARD, WARPED_CUTTING_BOARD);
    }

    private static RegistryObject<CuttingBoardBlock> registerCuttingBoard(String woodType, Block baseBlock) {
        return BLOCKS.createBlock(woodType + "_cutting_board", () -> new CuttingBoardBlock(BlockBehaviour.Properties.m_60926_((BlockBehaviour)baseBlock)), new Item.Properties());
    }

    public static Stream<RegistryObject<ButcherBlockCabinetBlock>> butcherBlockCabinets() {
        return Stream.of(OAK_BUTCHER_BLOCK_CABINET, SPRUCE_BUTCHER_BLOCK_CABINET, BIRCH_BUTCHER_BLOCK_CABINET, JUNGLE_BUTCHER_BLOCK_CABINET, ACACIA_BUTCHER_BLOCK_CABINET, DARK_OAK_BUTCHER_BLOCK_CABINET, MANGROVE_BUTCHER_BLOCK_CABINET, CHERRY_BUTCHER_BLOCK_CABINET, BAMBOO_BUTCHER_BLOCK_CABINET, CRIMSON_BUTCHER_BLOCK_CABINET, WARPED_BUTCHER_BLOCK_CABINET);
    }

    private static RegistryObject<ButcherBlockCabinetBlock> registerButcherBlockCabinet(String woodType, Block baseBlock) {
        SoundType soundType = baseBlock.m_49966_().m_60827_();
        BlockBehaviour.Properties properties = BlockBehaviour.Properties.m_60926_((BlockBehaviour)Blocks.f_50618_).m_284180_(baseBlock.m_284356_()).m_60918_(soundType);
        return BLOCKS.createBlock(woodType + "_butcher_block_cabinet", () -> new ButcherBlockCabinetBlock(properties), new Item.Properties());
    }

    public static void init() {
    }

    public static void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            BlockEntityTypeAccessor cuttingBoardAccessor = (BlockEntityTypeAccessor)ModBlockEntityTypes.CUTTING_BOARD.get();
            Set<Block> cuttingBoardValidBlocks = cuttingBoardAccessor.farmersassortment$getValidBlocks();
            HashSet<Block> updatedCuttingBoardBlocks = new HashSet<Block>(cuttingBoardValidBlocks);
            FABlocks.cuttingBoards().map(RegistryObject::get).forEach(updatedCuttingBoardBlocks::add);
            cuttingBoardAccessor.farmersassortment$setValidBlocks(updatedCuttingBoardBlocks);
            FABlocks.butcherBlockCabinets().map(RegistryObject::get).forEach(updatedCuttingBoardBlocks::add);
            BlockEntityTypeAccessor cookingPotAccessor = (BlockEntityTypeAccessor)ModBlockEntityTypes.COOKING_POT.get();
            Set<Block> cookingPotValidBlocks = cookingPotAccessor.farmersassortment$getValidBlocks();
            HashSet<Block> updatedCookingPotBlocks = new HashSet<Block>(cookingPotValidBlocks);
            boolean changed = false;
            Block block = (Block)COPPER_COOKING_POT.get();
            if (!updatedCookingPotBlocks.contains(block)) {
                updatedCookingPotBlocks.add(block);
                changed = true;
            }
            if (!updatedCookingPotBlocks.contains(block = (Block)GOLDEN_COOKING_POT.get())) {
                updatedCookingPotBlocks.add(block);
                changed = true;
            }
            if (!updatedCookingPotBlocks.contains(block = (Block)TERRACOTTA_COOKING_POT.get())) {
                updatedCookingPotBlocks.add(block);
                changed = true;
            }
            if (!updatedCookingPotBlocks.contains(block = (Block)ALABASTER_COOKING_POT.get())) {
                updatedCookingPotBlocks.add(block);
                changed = true;
            }
            if (changed) {
                cookingPotAccessor.farmersassortment$setValidBlocks(updatedCookingPotBlocks);
            }
        });
    }

    private static RegistryObject<CookingPotBlock> registerCookingPot(String name, MapColor mapColor, SoundType soundType, ResourceLocation id) {
        return BLOCKS.createBlockWithItem(name, () -> new CookingPotBlock(BlockBehaviour.Properties.m_284310_().m_284180_(mapColor).m_60913_(0.5f, 6.0f).m_60918_(soundType)), () -> new CookingPotItem(Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(id)), new Item.Properties().m_41487_(1)));
    }

    private static RegistryObject<CookingPotBlock> registerTerracottaCookingPot() {
        return BLOCKS.createBlockWithItem("terracotta_cooking_pot", () -> new TerracottaCookingPotBlock(BlockBehaviour.Properties.m_284310_().m_284180_(Blocks.f_50352_.m_284356_()).m_60913_(0.5f, 6.0f).m_60918_(SoundType.f_271215_)), () -> new TerracottaCookingPotItem(Objects.requireNonNull((Block)ForgeRegistries.BLOCKS.getValue(TERRACOTTA_COOKING_POT_ID)), new Item.Properties().m_41487_(1)));
    }
}

