/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.farmersassortment.core.item;

import com.tiomadre.farmersassortment.core.block.state.TerracottaCookingPotColor;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.item.CookingPotItem;

public class TerracottaCookingPotItem
extends CookingPotItem {
    private static final String BLOCK_STATE_TAG = "BlockStateTag";
    private static final String COLOR_TAG = "color";

    public TerracottaCookingPotItem(Block block, Item.Properties properties) {
        super(block, properties);
    }

    public static ItemStack applyColorToStack(ItemStack stack, TerracottaCookingPotColor color) {
        if (color == TerracottaCookingPotColor.NONE) {
            CompoundTag stateTag = stack.m_41737_(BLOCK_STATE_TAG);
            if (stateTag != null) {
                stateTag.m_128473_(COLOR_TAG);
                if (stateTag.m_128456_()) {
                    stack.m_41749_(BLOCK_STATE_TAG);
                }
            }
            return stack;
        }
        CompoundTag stateTag = stack.m_41698_(BLOCK_STATE_TAG);
        stateTag.m_128359_(COLOR_TAG, color.m_7912_());
        return stack;
    }

    public static TerracottaCookingPotColor getColor(ItemStack stack) {
        CompoundTag stateTag = stack.m_41737_(BLOCK_STATE_TAG);
        if (stateTag != null && stateTag.m_128425_(COLOR_TAG, 8)) {
            return TerracottaCookingPotColor.byName(stateTag.m_128461_(COLOR_TAG));
        }
        return TerracottaCookingPotColor.NONE;
    }

    public void m_7373_(@NotNull ItemStack stack, @Nullable Level level, @NotNull List<Component> tooltip, @NotNull TooltipFlag flag) {
        super.m_7373_(stack, level, tooltip, flag);
        TerracottaCookingPotColor color = TerracottaCookingPotItem.getColor(stack);
        if (color.isDyed() && color.dyeColor() != null) {
            tooltip.add((Component)Component.m_237110_((String)"tooltip.farmersassortment.terracotta_cooking_pot.dyed", (Object[])new Object[]{Component.m_237115_((String)("color.minecraft." + color.dyeColor().m_41065_()))}));
        } else {
            tooltip.add((Component)Component.m_237115_((String)"tooltip.farmersassortment.terracotta_cooking_pot.undyed"));
        }
    }
}

