/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.farmersassortment.core.block.state;

import java.util.Arrays;
import java.util.Locale;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.DyeColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum TerracottaCookingPotColor implements StringRepresentable
{
    NONE("none", null),
    WHITE("white", DyeColor.WHITE),
    ORANGE("orange", DyeColor.ORANGE),
    MAGENTA("magenta", DyeColor.MAGENTA),
    LIGHT_BLUE("light_blue", DyeColor.LIGHT_BLUE),
    YELLOW("yellow", DyeColor.YELLOW),
    LIME("lime", DyeColor.LIME),
    PINK("pink", DyeColor.PINK),
    GRAY("gray", DyeColor.GRAY),
    LIGHT_GRAY("light_gray", DyeColor.LIGHT_GRAY),
    CYAN("cyan", DyeColor.CYAN),
    PURPLE("purple", DyeColor.PURPLE),
    BLUE("blue", DyeColor.BLUE),
    BROWN("brown", DyeColor.BROWN),
    GREEN("green", DyeColor.GREEN),
    RED("red", DyeColor.RED),
    BLACK("black", DyeColor.BLACK);

    private final String name;
    @Nullable
    private final DyeColor dyeColor;

    private TerracottaCookingPotColor(String name, DyeColor dyeColor) {
        this.name = name;
        this.dyeColor = dyeColor;
    }

    @NotNull
    public String m_7912_() {
        return this.name;
    }

    public boolean isDyed() {
        return this.dyeColor != null;
    }

    @Nullable
    public DyeColor dyeColor() {
        return this.dyeColor;
    }

    public String textureName() {
        return this == NONE ? "terracotta_cooking_pot" : "terracotta_cooking_pot_" + this.name;
    }

    public ResourceLocation sideTexture() {
        return new ResourceLocation("farmersassortment", "block/" + this.textureName() + "_side");
    }

    public ResourceLocation topTexture() {
        return new ResourceLocation("farmersassortment", "block/" + this.textureName() + "_top");
    }

    public ResourceLocation bottomTexture() {
        return new ResourceLocation("farmersassortment", "block/" + this.textureName() + "_bottom");
    }

    public ResourceLocation partsTexture() {
        return new ResourceLocation("farmersassortment", "block/" + this.textureName() + "_parts");
    }

    public static TerracottaCookingPotColor fromDyeColor(DyeColor dyeColor) {
        return Arrays.stream(TerracottaCookingPotColor.values()).filter(color -> color.dyeColor == dyeColor).findFirst().orElse(NONE);
    }

    public static TerracottaCookingPotColor byName(String name) {
        return Arrays.stream(TerracottaCookingPotColor.values()).filter(color -> color.name.equals(name.toLowerCase(Locale.ROOT))).findFirst().orElse(NONE);
    }
}

