/*
 * Decompiled with CFR 0.152.
 */
package com.tiomadre.farmersassortment.core.block.entity;

import com.tiomadre.farmersassortment.core.block.ButcherBlockCabinetBlock;
import com.tiomadre.farmersassortment.core.registry.FABlockEntityTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.Tags;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.crafting.CuttingBoardRecipe;
import vectorwing.farmersdelight.common.mixin.accessor.RecipeManagerAccessor;
import vectorwing.farmersdelight.common.registry.ModAdvancements;
import vectorwing.farmersdelight.common.registry.ModRecipeTypes;
import vectorwing.farmersdelight.common.registry.ModSounds;
import vectorwing.farmersdelight.common.tag.ForgeTags;
import vectorwing.farmersdelight.common.utility.ItemUtils;
import vectorwing.farmersdelight.common.utility.TextUtils;

public class ButcherBlockCabinetBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> contents = NonNullList.m_122780_((int)27, (Object)ItemStack.f_41583_);
    private final ItemStackHandler boardInventory = this.createHandler();
    private final LazyOptional<IItemHandler> boardHandler = LazyOptional.of(() -> this.boardInventory);
    private ResourceLocation lastRecipeId;
    private boolean isItemCarvingBoard;
    private final ContainerOpenersCounter openersCounter = new ContainerOpenersCounter(){

        protected void m_142292_(Level level, BlockPos pos, BlockState state) {
            ButcherBlockCabinetBlockEntity.this.playCabinetSound(state, (SoundEvent)ModSounds.BLOCK_CABINET_OPEN.get());
            ButcherBlockCabinetBlockEntity.this.updateBlockState(state, true);
        }

        protected void m_142289_(Level level, BlockPos pos, BlockState state) {
            ButcherBlockCabinetBlockEntity.this.playCabinetSound(state, (SoundEvent)ModSounds.BLOCK_CABINET_CLOSE.get());
            ButcherBlockCabinetBlockEntity.this.updateBlockState(state, false);
        }

        protected void m_142148_(Level level, BlockPos pos, BlockState state, int i, int j) {
        }

        protected boolean m_142718_(Player player) {
            AbstractContainerMenu abstractContainerMenu = player.f_36096_;
            if (abstractContainerMenu instanceof ChestMenu) {
                ChestMenu chestMenu = (ChestMenu)abstractContainerMenu;
                Container container = chestMenu.m_39261_();
                return container == ButcherBlockCabinetBlockEntity.this;
            }
            return false;
        }
    };

    public ButcherBlockCabinetBlockEntity(BlockPos pos, BlockState state) {
        super((BlockEntityType)FABlockEntityTypes.BUTCHER_BLOCK_CABINET.get(), pos, state);
    }

    public void m_142466_(CompoundTag tag) {
        super.m_142466_(tag);
        this.contents = NonNullList.m_122780_((int)this.m_6643_(), (Object)ItemStack.f_41583_);
        if (!this.m_59631_(tag)) {
            ContainerHelper.m_18980_((CompoundTag)tag, this.contents);
        }
        this.isItemCarvingBoard = tag.m_128471_("IsItemCarved");
        this.boardInventory.deserializeNBT(tag.m_128469_("Board"));
    }

    public void m_183515_(CompoundTag tag) {
        super.m_183515_(tag);
        if (!this.m_59634_(tag)) {
            ContainerHelper.m_18973_((CompoundTag)tag, this.contents);
        }
        tag.m_128365_("Board", (Tag)this.boardInventory.serializeNBT());
        tag.m_128379_("IsItemCarved", this.isItemCarvingBoard);
    }

    public int m_6643_() {
        return 27;
    }

    protected NonNullList<ItemStack> m_7086_() {
        return this.contents;
    }

    protected void m_6520_(NonNullList<ItemStack> items) {
        this.contents = items;
    }

    protected Component m_6820_() {
        return Component.m_237115_((String)"container.farmersassortment.butcher_block_cabinet");
    }

    protected AbstractContainerMenu m_6555_(int id, Inventory player) {
        return ChestMenu.m_39237_((int)id, (Inventory)player, (Container)this);
    }

    public void m_5856_(Player player) {
        if (this.f_58857_ != null && !this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155452_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void m_5785_(Player player) {
        if (this.f_58857_ != null && !this.f_58859_ && !player.m_5833_()) {
            this.openersCounter.m_155468_(player, this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    public void recheckOpen() {
        if (this.f_58857_ != null && !this.f_58859_) {
            this.openersCounter.m_155476_(this.f_58857_, this.m_58899_(), this.m_58900_());
        }
    }

    private void updateBlockState(BlockState state, boolean open) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_7731_(this.f_58858_, (BlockState)state.m_61124_((Property)ButcherBlockCabinetBlock.OPEN, (Comparable)Boolean.valueOf(open)), 3);
        }
    }

    private void playCabinetSound(BlockState state, SoundEvent sound) {
        if (this.f_58857_ == null) {
            return;
        }
        Direction facing = (Direction)state.m_61143_((Property)ButcherBlockCabinetBlock.FACING);
        Vec3 offset = Vec3.m_82512_((Vec3i)this.f_58858_).m_82549_(Vec3.m_82528_((Vec3i)facing.m_122436_()).m_82490_(0.5));
        this.f_58857_.m_6263_(null, offset.f_82479_, offset.f_82480_, offset.f_82481_, sound, SoundSource.BLOCKS, 0.5f, this.f_58857_.f_46441_.m_188501_() * 0.1f + 0.9f);
    }

    public boolean addBoardItem(ItemStack stack) {
        if (this.isBoardEmpty() && !stack.m_41619_()) {
            this.boardInventory.setStackInSlot(0, stack.m_41620_(1));
            this.isItemCarvingBoard = false;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public boolean carveToolOnBoard(ItemStack tool) {
        if (this.addBoardItem(tool)) {
            this.isItemCarvingBoard = true;
            this.inventoryChanged();
            return true;
        }
        return false;
    }

    public ItemStack removeBoardItem() {
        if (!this.isBoardEmpty()) {
            this.isItemCarvingBoard = false;
            ItemStack stack = this.boardInventory.getStackInSlot(0).m_41620_(1);
            this.inventoryChanged();
            return stack;
        }
        return ItemStack.f_41583_;
    }

    public ItemStack getBoardItem() {
        return this.boardInventory.getStackInSlot(0);
    }

    public boolean isBoardEmpty() {
        return this.boardInventory.getStackInSlot(0).m_41619_();
    }

    public boolean isItemCarvingBoard() {
        return this.isItemCarvingBoard;
    }

    public boolean processBoardItemUsingTool(ItemStack toolStack, @Nullable Player player) {
        if (this.f_58857_ == null || this.isItemCarvingBoard) {
            return false;
        }
        Optional<CuttingBoardRecipe> recipe = this.getMatchingRecipe(new RecipeWrapper((IItemHandlerModifiable)this.boardInventory), toolStack, player);
        recipe.ifPresent(result -> {
            List outputs = result.rollResults(this.f_58857_.f_46441_, EnchantmentHelper.m_44843_((Enchantment)Enchantments.f_44987_, (ItemStack)toolStack));
            for (ItemStack stack : outputs) {
                Direction direction = ((Direction)this.m_58900_().m_61143_((Property)ButcherBlockCabinetBlock.FACING)).m_122428_();
                ItemUtils.spawnItemEntity((Level)this.f_58857_, (ItemStack)stack.m_41777_(), (double)((double)this.f_58858_.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.2), (double)((double)this.f_58858_.m_123342_() + 0.2), (double)((double)this.f_58858_.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.2), (double)((float)direction.m_122429_() * 0.2f), (double)0.0, (double)((float)direction.m_122431_() * 0.2f));
            }
            if (player != null) {
                toolStack.m_41622_(1, (LivingEntity)player, p -> p.m_21166_(EquipmentSlot.MAINHAND));
            } else if (toolStack.m_220157_(1, this.f_58857_.f_46441_, null)) {
                toolStack.m_41764_(0);
            }
            this.playProcessingSound(result.getSoundEventID(), toolStack, this.getBoardItem());
            this.removeBoardItem();
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModAdvancements.CUTTING_BOARD.trigger(serverPlayer);
            }
        });
        return recipe.isPresent();
    }

    private Optional<CuttingBoardRecipe> getMatchingRecipe(RecipeWrapper wrapper, ItemStack toolStack, @Nullable Player player) {
        CuttingBoardRecipe cuttingBoardRecipe;
        Recipe recipe;
        if (this.f_58857_ == null) {
            return Optional.empty();
        }
        if (this.lastRecipeId != null && (recipe = (Recipe)((RecipeManagerAccessor)this.f_58857_.m_7465_()).getRecipeMap((RecipeType)ModRecipeTypes.CUTTING.get()).get(this.lastRecipeId)) instanceof CuttingBoardRecipe && (cuttingBoardRecipe = (CuttingBoardRecipe)recipe).matches(wrapper, this.f_58857_) && cuttingBoardRecipe.getTool().test(toolStack)) {
            return Optional.of(cuttingBoardRecipe);
        }
        List recipes = this.f_58857_.m_7465_().m_44056_((RecipeType)ModRecipeTypes.CUTTING.get(), (Container)wrapper, this.f_58857_);
        if (recipes.isEmpty()) {
            if (player != null) {
                player.m_5661_((Component)TextUtils.getTranslation((String)"block.cutting_board.invalid_item", (Object[])new Object[0]), true);
            }
            return Optional.empty();
        }
        Optional<CuttingBoardRecipe> recipe2 = recipes.stream().filter(r -> r.getTool().test(toolStack)).findFirst();
        if (recipe2.isEmpty()) {
            if (player != null) {
                player.m_5661_((Component)TextUtils.getTranslation((String)"block.cutting_board.invalid_tool", (Object[])new Object[0]), true);
            }
            return Optional.empty();
        }
        this.lastRecipeId = recipe2.get().m_6423_();
        return recipe2;
    }

    public void playProcessingSound(String soundEventId, ItemStack tool, ItemStack boardItem) {
        SoundEvent sound = (SoundEvent)ForgeRegistries.SOUND_EVENTS.getValue(new ResourceLocation(soundEventId));
        if (sound != null) {
            this.playSound(sound, 1.0f, 1.0f);
        } else if (tool.m_204117_(Tags.Items.SHEARS)) {
            this.playSound(SoundEvents.f_12344_, 1.0f, 1.0f);
        } else if (tool.m_204117_(ForgeTags.TOOLS_KNIVES)) {
            this.playSound((SoundEvent)ModSounds.BLOCK_CUTTING_BOARD_KNIFE.get(), 0.8f, 1.0f);
        } else {
            Item item = boardItem.m_41720_();
            if (item instanceof BlockItem) {
                BlockItem blockItem = (BlockItem)item;
                Block block = blockItem.m_40614_();
                SoundType soundType = block.m_49966_().m_60827_();
                this.playSound(soundType.m_56775_(), 1.0f, 0.8f);
            } else {
                this.playSound(SoundEvents.f_12630_, 1.0f, 0.8f);
            }
        }
    }

    public void playSound(SoundEvent sound, float volume, float pitch) {
        if (this.f_58857_ != null) {
            this.f_58857_.m_6263_(null, (double)((float)this.f_58858_.m_123341_() + 0.5f), (double)((float)this.f_58858_.m_123342_() + 0.5f), (double)((float)this.f_58858_.m_123343_() + 0.5f), sound, SoundSource.BLOCKS, volume, pitch);
        }
    }

    private ItemStackHandler createHandler() {
        return new ItemStackHandler(){

            public int getSlotLimit(int slot) {
                return 1;
            }

            protected void onContentsChanged(int slot) {
                ButcherBlockCabinetBlockEntity.this.inventoryChanged();
            }
        };
    }

    private void inventoryChanged() {
        this.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.f_58858_, this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public static void spawnCuttingParticles(Level level, BlockPos pos, ItemStack stack, int count) {
        for (int i = 0; i < count; ++i) {
            Vec3 vec3 = new Vec3((level.f_46441_.m_188500_() - 0.5) * 0.1, Math.random() * 0.1 + 0.1, (level.f_46441_.m_188500_() - 0.5) * 0.1);
            if (level instanceof ServerLevel) {
                ServerLevel serverLevel = (ServerLevel)level;
                serverLevel.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, 1, vec3.f_82479_, vec3.f_82480_ + 0.05, vec3.f_82481_, 0.0);
                continue;
            }
            level.m_7106_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, stack), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 1.0, (double)pos.m_123343_() + 0.5, vec3.f_82479_, vec3.f_82480_, vec3.f_82481_);
        }
    }

    public <T> LazyOptional<T> getCapability(Capability<T> capability, @Nullable Direction side) {
        if (capability == ForgeCapabilities.ITEM_HANDLER && side == Direction.UP) {
            return this.boardHandler.cast();
        }
        return super.getCapability(capability, side);
    }

    public void m_7651_() {
        super.m_7651_();
        this.boardHandler.invalidate();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket packet) {
        this.m_142466_(packet.m_131708_());
    }

    public void handleUpdateTag(CompoundTag tag) {
        this.m_142466_(tag);
    }
}

