/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import moze_intel.projecte.PECore;
import moze_intel.projecte.config.ProjectEConfig;
import moze_intel.projecte.gameObjs.PETags;
import moze_intel.projecte.gameObjs.registries.PESoundEvents;
import moze_intel.projecte.utils.ItemHelper;
import moze_intel.projecte.utils.LazyTagLookup;
import moze_intel.projecte.utils.NovaExplosion;
import moze_intel.projecte.utils.PlayerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Enemy;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.Projectile;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.BaseCoralWallFanBlock;
import net.minecraft.world.level.block.BaseFireBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BucketPickup;
import net.minecraft.world.level.block.CampfireBlock;
import net.minecraft.world.level.block.DoublePlantBlock;
import net.minecraft.world.level.block.FlowerBlock;
import net.minecraft.world.level.block.GrassBlock;
import net.minecraft.world.level.block.HangingRootsBlock;
import net.minecraft.world.level.block.LiquidBlockContainer;
import net.minecraft.world.level.block.MossBlock;
import net.minecraft.world.level.block.NetherSproutsBlock;
import net.minecraft.world.level.block.NetherWartBlock;
import net.minecraft.world.level.block.NetherrackBlock;
import net.minecraft.world.level.block.NyliumBlock;
import net.minecraft.world.level.block.RootsBlock;
import net.minecraft.world.level.block.SnowLayerBlock;
import net.minecraft.world.level.block.TntBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FlowingFluid;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.IForgeShearable;
import net.minecraftforge.common.IPlantable;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.event.level.ExplosionEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.fluids.IFluidBlock;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import net.minecraftforge.registries.ForgeRegistries;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class WorldHelper {
    private static final Predicate<Entity> SWRG_REPEL_PREDICATE = entity -> WorldHelper.validRepelEntity(entity, PETags.Entities.BLACKLIST_SWRG);
    private static final Predicate<Entity> INTERDICTION_REPEL_PREDICATE = entity -> WorldHelper.validRepelEntity(entity, PETags.Entities.BLACKLIST_INTERDICTION);
    private static final Predicate<Entity> INTERDICTION_REPEL_HOSTILE_PREDICATE = entity -> WorldHelper.validRepelEntity(entity, PETags.Entities.BLACKLIST_INTERDICTION) && (entity instanceof Enemy || entity instanceof Projectile);

    public static void createLootDrop(List<ItemStack> drops, Level level, BlockPos pos) {
        WorldHelper.createLootDrop(drops, level, pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
    }

    public static void createLootDrop(List<ItemStack> drops, Level level, double x, double y, double z) {
        if (!drops.isEmpty()) {
            ItemHelper.compactItemListNoStacksize(drops);
            for (ItemStack drop : drops) {
                level.m_7967_((Entity)new ItemEntity(level, x, y, z, drop));
            }
        }
    }

    public static void createNovaExplosion(Level level, Entity exploder, double x, double y, double z, float power) {
        NovaExplosion explosion = new NovaExplosion(level, exploder, x, y, z, power, true, Explosion.BlockInteraction.DESTROY);
        if (!MinecraftForge.EVENT_BUS.post((Event)new ExplosionEvent.Start(level, (Explosion)explosion))) {
            explosion.m_46061_();
            explosion.m_46075_(true);
        }
    }

    public static void drainFluid(Level level, BlockPos pos, BlockState state, Fluid toMatch) {
        IFluidBlock fluidBlock;
        Block block = state.m_60734_();
        if (block instanceof IFluidBlock && (fluidBlock = (IFluidBlock)block).getFluid().m_6212_(toMatch)) {
            fluidBlock.drain(level, pos, IFluidHandler.FluidAction.EXECUTE);
        } else if (block instanceof BucketPickup) {
            BucketPickup bucketPickup = (BucketPickup)block;
            bucketPickup.m_142598_((LevelAccessor)level, pos, state);
        }
    }

    public static void dropInventory(IItemHandler inv, Level level, BlockPos pos) {
        if (inv == null) {
            return;
        }
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack stack = inv.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            level.m_7967_((Entity)new ItemEntity(level, (double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), stack));
        }
    }

    public static void extinguishNearby(Level level, Player player) {
        BlockPos.m_121990_((BlockPos)player.m_20183_().m_7918_(-1, -1, -1), (BlockPos)player.m_20183_().m_7918_(1, 1, 1)).forEach(pos -> {
            if (level.m_8055_(pos = pos.m_7949_()).m_60734_() == Blocks.f_50083_ && PlayerHelper.hasBreakPermission((ServerPlayer)player, pos)) {
                level.m_7471_(pos, false);
            }
        });
    }

    public static void freezeInBoundingBox(Level level, AABB box, Player player, boolean random) {
        for (BlockPos pos : WorldHelper.getPositionsFromBox(box)) {
            BlockState state = level.m_8055_(pos);
            Block b = state.m_60734_();
            pos = pos.m_7949_();
            if (!(b != Blocks.f_49990_ || random && level.f_46441_.m_188503_(128) != 0)) {
                if (player != null) {
                    PlayerHelper.checkedReplaceBlock((ServerPlayer)player, pos, Blocks.f_50126_.m_49966_());
                    continue;
                }
                level.m_46597_(pos, Blocks.f_50126_.m_49966_());
                continue;
            }
            if (!Block.m_49918_((VoxelShape)state.m_60812_((BlockGetter)level, pos.m_7495_()), (Direction)Direction.UP)) continue;
            BlockPos up = pos.m_7494_();
            BlockState stateUp = level.m_8055_(up);
            BlockState newState = null;
            if (stateUp.m_60795_() && (!random || level.f_46441_.m_188503_(128) == 0)) {
                newState = Blocks.f_50125_.m_49966_();
            } else if (stateUp.m_60734_() == Blocks.f_50125_ && (Integer)stateUp.m_61143_((Property)SnowLayerBlock.f_56581_) < 8 && level.f_46441_.m_188503_(512) == 0) {
                newState = (BlockState)stateUp.m_61124_((Property)SnowLayerBlock.f_56581_, (Comparable)Integer.valueOf((Integer)stateUp.m_61143_((Property)SnowLayerBlock.f_56581_) + 1));
            }
            if (newState == null) continue;
            if (player != null) {
                PlayerHelper.checkedReplaceBlock((ServerPlayer)player, up, newState);
                continue;
            }
            level.m_46597_(up, newState);
        }
    }

    public static boolean isLiquidContainerForFluid(BlockGetter level, BlockPos pos, BlockState state, Fluid fluid) {
        LiquidBlockContainer liquidBlockContainer;
        Block block = state.m_60734_();
        return block instanceof LiquidBlockContainer && (liquidBlockContainer = (LiquidBlockContainer)block).m_6044_(level, pos, state, fluid);
    }

    public static void placeFluid(@Nullable ServerPlayer player, Level level, BlockPos pos, Direction sideHit, FlowingFluid fluid, boolean checkWaterVaporize) {
        if (WorldHelper.isLiquidContainerForFluid((BlockGetter)level, pos, level.m_8055_(pos), (Fluid)fluid)) {
            WorldHelper.placeFluid(player, level, pos, fluid, checkWaterVaporize);
        } else {
            WorldHelper.placeFluid(player, level, pos.m_121945_(sideHit), fluid, checkWaterVaporize);
        }
    }

    public static void placeFluid(@Nullable ServerPlayer player, Level level, BlockPos pos, FlowingFluid fluid, boolean checkWaterVaporize) {
        BlockState blockState = level.m_8055_(pos);
        if (checkWaterVaporize && level.m_6042_().f_63857_() && fluid.m_205067_(FluidTags.f_13131_)) {
            level.m_5594_(null, pos, SoundEvents.f_11937_, SoundSource.PLAYERS, 0.5f, 2.6f + (level.f_46441_.m_188501_() - level.f_46441_.m_188501_()) * 0.8f);
            for (int l = 0; l < 8; ++l) {
                level.m_7106_((ParticleOptions)ParticleTypes.f_123755_, (double)pos.m_123341_() + Math.random(), (double)pos.m_123342_() + Math.random(), (double)pos.m_123343_() + Math.random(), 0.0, 0.0, 0.0);
            }
        } else if (WorldHelper.isLiquidContainerForFluid((BlockGetter)level, pos, blockState, (Fluid)fluid)) {
            ((LiquidBlockContainer)blockState.m_60734_()).m_7361_((LevelAccessor)level, pos, blockState, fluid.m_76068_(false));
            level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
        } else {
            if (blockState.m_60722_((Fluid)fluid) && !blockState.m_278721_()) {
                level.m_46961_(pos, true);
            }
            if (player == null) {
                level.m_46597_(pos, fluid.m_76145_().m_76188_());
                level.m_142346_(null, GameEvent.f_157769_, pos);
            } else if (PlayerHelper.checkedPlaceBlock(player, pos, fluid.m_76145_().m_76188_())) {
                level.m_142346_((Entity)player, GameEvent.f_157769_, pos);
            }
        }
    }

    @Nullable
    public static IItemHandler getItemHandler(@NotNull BlockEntity blockEntity, @Nullable Direction direction) {
        Optional capability = blockEntity.getCapability(ForgeCapabilities.ITEM_HANDLER, direction).resolve();
        if (capability.isPresent()) {
            return (IItemHandler)capability.get();
        }
        if (blockEntity instanceof WorldlyContainer) {
            WorldlyContainer container = (WorldlyContainer)blockEntity;
            return new SidedInvWrapper(container, direction);
        }
        if (blockEntity instanceof Container) {
            Container container = (Container)blockEntity;
            return new InvWrapper(container);
        }
        return null;
    }

    public static AABB getBroadDeepBox(BlockPos pos, Direction direction, int offset) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> new AABB((double)(pos.m_123341_() - offset), (double)(pos.m_123342_() - offset), (double)(pos.m_123343_() - offset), (double)pos.m_123341_(), (double)(pos.m_123342_() + offset), (double)(pos.m_123343_() + offset));
            case Direction.WEST -> new AABB((double)pos.m_123341_(), (double)(pos.m_123342_() - offset), (double)(pos.m_123343_() - offset), (double)(pos.m_123341_() + offset), (double)(pos.m_123342_() + offset), (double)(pos.m_123343_() + offset));
            case Direction.UP -> new AABB((double)(pos.m_123341_() - offset), (double)(pos.m_123342_() - offset), (double)(pos.m_123343_() - offset), (double)(pos.m_123341_() + offset), (double)pos.m_123342_(), (double)(pos.m_123343_() + offset));
            case Direction.DOWN -> new AABB((double)(pos.m_123341_() - offset), (double)pos.m_123342_(), (double)(pos.m_123343_() - offset), (double)(pos.m_123341_() + offset), (double)(pos.m_123342_() + offset), (double)(pos.m_123343_() + offset));
            case Direction.SOUTH -> new AABB((double)(pos.m_123341_() - offset), (double)(pos.m_123342_() - offset), (double)(pos.m_123343_() - offset), (double)(pos.m_123341_() + offset), (double)(pos.m_123342_() + offset), (double)pos.m_123343_());
            case Direction.NORTH -> new AABB((double)(pos.m_123341_() - offset), (double)(pos.m_123342_() - offset), (double)pos.m_123343_(), (double)(pos.m_123341_() + offset), (double)(pos.m_123342_() + offset), (double)(pos.m_123343_() + offset));
        };
    }

    public static AABB getDeepBox(BlockPos pos, Direction direction, int depth) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST -> new AABB((double)(pos.m_123341_() - depth), (double)(pos.m_123342_() - 1), (double)(pos.m_123343_() - 1), (double)pos.m_123341_(), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
            case Direction.WEST -> new AABB((double)pos.m_123341_(), (double)(pos.m_123342_() - 1), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + depth), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
            case Direction.UP -> new AABB((double)(pos.m_123341_() - 1), (double)(pos.m_123342_() - depth), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)pos.m_123342_(), (double)(pos.m_123343_() + 1));
            case Direction.DOWN -> new AABB((double)(pos.m_123341_() - 1), (double)pos.m_123342_(), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + depth), (double)(pos.m_123343_() + 1));
            case Direction.SOUTH -> new AABB((double)(pos.m_123341_() - 1), (double)(pos.m_123342_() - 1), (double)(pos.m_123343_() - depth), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)pos.m_123343_());
            case Direction.NORTH -> new AABB((double)(pos.m_123341_() - 1), (double)(pos.m_123342_() - 1), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + depth));
        };
    }

    public static AABB getBroadBox(BlockPos pos, Direction direction, int size) {
        return switch (direction) {
            default -> throw new IncompatibleClassChangeError();
            case Direction.EAST, Direction.WEST -> new AABB((double)pos.m_123341_(), (double)(pos.m_123342_() - size), (double)(pos.m_123343_() - size), (double)pos.m_123341_(), (double)(pos.m_123342_() + size), (double)(pos.m_123343_() + size));
            case Direction.UP, Direction.DOWN -> new AABB((double)(pos.m_123341_() - size), (double)pos.m_123342_(), (double)(pos.m_123343_() - size), (double)(pos.m_123341_() + size), (double)pos.m_123342_(), (double)(pos.m_123343_() + size));
            case Direction.SOUTH, Direction.NORTH -> new AABB((double)(pos.m_123341_() - size), (double)(pos.m_123342_() - size), (double)pos.m_123343_(), (double)(pos.m_123341_() + size), (double)(pos.m_123342_() + size), (double)pos.m_123343_());
        };
    }

    public static AABB getFlatYBox(BlockPos pos, int offset) {
        return new AABB((double)(pos.m_123341_() - offset), (double)pos.m_123342_(), (double)(pos.m_123343_() - offset), (double)(pos.m_123341_() + offset), (double)pos.m_123342_(), (double)(pos.m_123343_() + offset));
    }

    public static Iterable<BlockPos> getPositionsFromBox(AABB box) {
        return WorldHelper.getPositionsFromBox(BlockPos.m_274561_((double)box.f_82288_, (double)box.f_82289_, (double)box.f_82290_), BlockPos.m_274561_((double)box.f_82291_, (double)box.f_82292_, (double)box.f_82293_));
    }

    public static Iterable<BlockPos> getPositionsFromBox(BlockPos corner1, BlockPos corner2) {
        return () -> BlockPos.m_121990_((BlockPos)corner1, (BlockPos)corner2).iterator();
    }

    public static List<BlockEntity> getBlockEntitiesWithinAABB(Level level, AABB bBox) {
        ArrayList<BlockEntity> list = new ArrayList<BlockEntity>();
        for (BlockPos pos : WorldHelper.getPositionsFromBox(bBox)) {
            BlockEntity blockEntity = WorldHelper.getBlockEntity((BlockGetter)level, pos);
            if (blockEntity == null) continue;
            list.add(blockEntity);
        }
        return list;
    }

    public static void gravitateEntityTowards(Entity ent, double x, double y, double z) {
        double dZ;
        double dY;
        double dX = x - ent.m_20185_();
        double dist = Math.sqrt(dX * dX + (dY = y - ent.m_20186_()) * dY + (dZ = z - ent.m_20189_()) * dZ);
        double vel = 1.0 - dist / 15.0;
        if (vel > 0.0) {
            vel *= vel;
            ent.m_20256_(ent.m_20184_().m_82520_(dX / dist * vel * 0.1, dY / dist * vel * 0.2, dZ / dist * vel * 0.1));
        }
    }

    public static void growNearbyRandomly(boolean harvest, Level level, BlockPos pos, Player player) {
        if (!(level instanceof ServerLevel)) {
            return;
        }
        ServerLevel serverLevel = (ServerLevel)level;
        boolean grewWater = false;
        int chance = harvest ? 16 : 32;
        for (BlockPos currentPos : WorldHelper.getPositionsFromBox(pos.m_7918_(-5, -3, -5), pos.m_7918_(5, 3, 5))) {
            BlockState state = serverLevel.m_8055_(currentPos = currentPos.m_7949_());
            Block crop = state.m_60734_();
            if (crop instanceof IForgeShearable || crop instanceof FlowerBlock || crop instanceof DoublePlantBlock || crop instanceof RootsBlock || crop instanceof NetherSproutsBlock || crop instanceof HangingRootsBlock) {
                if (!harvest) continue;
                WorldHelper.harvestBlock((Level)serverLevel, currentPos, (ServerPlayer)player);
                continue;
            }
            if (crop instanceof BonemealableBlock) {
                BonemealableBlock growable = (BonemealableBlock)crop;
                if (!growable.m_7370_((LevelReader)serverLevel, currentPos, state, false)) {
                    if (!harvest || state.m_204336_(PETags.Blocks.BLACKLIST_HARVEST) || WorldHelper.leaveBottomBlock(crop) && !serverLevel.m_8055_(currentPos.m_7495_()).m_60713_(crop)) continue;
                    WorldHelper.harvestBlock((Level)serverLevel, currentPos, (ServerPlayer)player);
                    continue;
                }
                if (!ProjectEConfig.server.items.harvBandGrass.get() && WorldHelper.isGrassLikeBlock(crop) || serverLevel.f_46441_.m_188503_(chance) != 0) continue;
                growable.m_214148_(serverLevel, serverLevel.f_46441_, currentPos, state);
                level.m_46796_(1505, currentPos, 0);
                continue;
            }
            if (crop instanceof IPlantable) {
                int i;
                if (serverLevel.f_46441_.m_188503_(chance / 4) == 0) {
                    for (i = 0; i < (harvest ? 8 : 4); ++i) {
                        state.m_222972_(serverLevel, currentPos, serverLevel.f_46441_);
                    }
                }
                if (!harvest) continue;
                if (crop == Blocks.f_50130_ || crop == Blocks.f_50128_) {
                    if (!serverLevel.m_8055_(currentPos.m_7494_()).m_60713_(crop) || !serverLevel.m_8055_(currentPos.m_6630_(2)).m_60713_(crop)) continue;
                    int n = i = crop == Blocks.f_50130_ ? 1 : 0;
                    while (i < 3) {
                        WorldHelper.harvestBlock((Level)serverLevel, currentPos.m_6630_(i), (ServerPlayer)player);
                        ++i;
                    }
                    continue;
                }
                if (crop != Blocks.f_50200_ || (Integer)state.m_61143_((Property)NetherWartBlock.f_54967_) != 3) continue;
                WorldHelper.harvestBlock((Level)serverLevel, currentPos, (ServerPlayer)player);
                continue;
            }
            if (grewWater || serverLevel.f_46441_.m_188503_(512) != 0 || !WorldHelper.growWaterPlant(serverLevel, currentPos, state, null)) continue;
            level.m_46796_(1505, currentPos, 0);
            grewWater = true;
        }
    }

    private static boolean leaveBottomBlock(Block crop) {
        return crop == Blocks.f_50576_ || crop == Blocks.f_50571_;
    }

    private static boolean isGrassLikeBlock(Block crop) {
        return crop instanceof GrassBlock || crop instanceof NyliumBlock || crop instanceof NetherrackBlock || crop instanceof MossBlock;
    }

    private static void harvestBlock(Level level, BlockPos pos, @Nullable ServerPlayer player) {
        if (player == null || PlayerHelper.hasBreakPermission(player, pos)) {
            level.m_46953_(pos, true, (Entity)player);
        }
    }

    public static boolean growWaterPlant(ServerLevel level, BlockPos pos, BlockState state, @Nullable Direction side) {
        boolean success = false;
        if (state.m_60713_(Blocks.f_49990_) && state.m_60819_().m_76186_() == 8) {
            RandomSource random = level.m_213780_();
            block0: for (int i = 0; i < 128; ++i) {
                BlockPos blockpos = pos;
                for (int j = 0; j < i / 16; ++j) {
                    if (level.m_8055_(blockpos = blockpos.m_7918_(random.m_188503_(3) - 1, (random.m_188503_(3) - 1) * random.m_188503_(3) / 2, random.m_188503_(3) - 1)).m_60838_((BlockGetter)level, blockpos)) continue block0;
                }
                BlockState newState = Blocks.f_50037_.m_49966_();
                Holder biome = level.m_204166_(blockpos);
                if (biome.m_203565_(Biomes.f_48166_)) {
                    if (i == 0 && side != null && side.m_122434_().m_122479_()) {
                        if ((newState = WorldHelper.getRandomState((TagKey<Block>)BlockTags.f_13052_, random, newState)).m_61138_((Property)BaseCoralWallFanBlock.f_49192_)) {
                            newState = (BlockState)newState.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)side);
                        }
                    } else if (random.m_188503_(4) == 0) {
                        newState = WorldHelper.getRandomState((TagKey<Block>)BlockTags.f_13050_, random, newState);
                    }
                }
                if (newState.m_204338_(BlockTags.f_13052_, s -> s.m_61138_((Property)BaseCoralWallFanBlock.f_49192_))) {
                    for (int k = 0; !newState.m_60710_((LevelReader)level, blockpos) && k < 4; ++k) {
                        newState = (BlockState)newState.m_61124_((Property)BaseCoralWallFanBlock.f_49192_, (Comparable)Direction.Plane.HORIZONTAL.m_235690_(random));
                    }
                }
                if (!newState.m_60710_((LevelReader)level, blockpos)) continue;
                BlockState stateToReplace = level.m_8055_(blockpos);
                if (stateToReplace.m_60713_(Blocks.f_49990_) && stateToReplace.m_60819_().m_76186_() == 8) {
                    level.m_46597_(blockpos, newState);
                    success = true;
                    continue;
                }
                if (!stateToReplace.m_60713_(Blocks.f_50037_) || random.m_188503_(10) != 0) continue;
                ((BonemealableBlock)Blocks.f_50037_).m_214148_(level, random, blockpos, stateToReplace);
                success = true;
            }
        }
        return success;
    }

    private static BlockState getRandomState(TagKey<Block> key, RandomSource random, BlockState fallback) {
        return LazyTagLookup.tagManager(ForgeRegistries.BLOCKS).getTag(key).getRandomElement(random).map(Block::m_49966_).orElse(fallback);
    }

    public static int harvestVein(Level level, Player player, ItemStack stack, BlockPos pos, Block target, List<ItemStack> currentDrops, int numMined) {
        if (numMined >= 250) {
            return numMined;
        }
        AABB b = new AABB((double)(pos.m_123341_() - 1), (double)(pos.m_123342_() - 1), (double)(pos.m_123343_() - 1), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
        for (BlockPos currentPos : WorldHelper.getPositionsFromBox(b)) {
            BlockState currentState = level.m_8055_(currentPos);
            if (currentState.m_60734_() != target || !PlayerHelper.hasBreakPermission((ServerPlayer)player, currentPos = currentPos.m_7949_())) continue;
            ++numMined;
            currentDrops.addAll(Block.m_49874_((BlockState)currentState, (ServerLevel)((ServerLevel)level), (BlockPos)currentPos, (BlockEntity)WorldHelper.getBlockEntity((BlockGetter)level, currentPos), (Entity)player, (ItemStack)stack));
            level.m_7471_(currentPos, false);
            if ((numMined = WorldHelper.harvestVein(level, player, stack, currentPos, target, currentDrops, numMined)) < 250) continue;
            break;
        }
        return numMined;
    }

    public static void igniteNearby(Level level, Player player) {
        for (BlockPos pos : BlockPos.m_121940_((BlockPos)player.m_20183_().m_7918_(-8, -5, -8), (BlockPos)player.m_20183_().m_7918_(8, 5, 8))) {
            if (level.f_46441_.m_188503_(128) != 0 || !level.m_46859_(pos)) continue;
            PlayerHelper.checkedPlaceBlock((ServerPlayer)player, pos.m_7949_(), Blocks.f_50083_.m_49966_());
        }
    }

    private static boolean validRepelEntity(Entity entity, TagKey<EntityType<?>> blacklistTag) {
        if (!entity.m_5833_() && !entity.m_6095_().m_204039_(blacklistTag)) {
            if (entity instanceof Projectile) {
                return !entity.m_20096_();
            }
            return entity instanceof Mob;
        }
        return false;
    }

    public static void repelEntitiesInterdiction(Level level, AABB effectBounds, double x, double y, double z) {
        Vec3 vec = new Vec3(x, y, z);
        Predicate<Entity> repelPredicate = ProjectEConfig.server.effects.interdictionMode.get() ? INTERDICTION_REPEL_HOSTILE_PREDICATE : INTERDICTION_REPEL_PREDICATE;
        for (Entity ent : level.m_6443_(Entity.class, effectBounds, repelPredicate)) {
            WorldHelper.repelEntity(vec, ent);
        }
    }

    public static void repelEntitiesSWRG(Level level, AABB effectBounds, Player player) {
        Vec3 playerVec = player.m_20182_();
        for (Entity ent : level.m_6443_(Entity.class, effectBounds, SWRG_REPEL_PREDICATE)) {
            if (ent instanceof Projectile) {
                Projectile projectile = (Projectile)ent;
                Entity owner = projectile.m_19749_();
                if (level.m_5776_() && owner == null || owner != null && player.m_20148_().equals(owner.m_20148_())) continue;
            }
            WorldHelper.repelEntity(playerVec, ent);
        }
    }

    private static void repelEntity(Vec3 vec, Entity entity) {
        Vec3 t = new Vec3(entity.m_20185_(), entity.m_20186_(), entity.m_20189_());
        Vec3 r = new Vec3(t.f_82479_ - vec.f_82479_, t.f_82480_ - vec.f_82480_, t.f_82481_ - vec.f_82481_);
        double distance = vec.m_82554_(t) + 0.1;
        entity.m_20256_(entity.m_20184_().m_82549_(r.m_82490_(0.6666666666666666 / distance)));
    }

    @NotNull
    public static InteractionResult igniteBlock(UseOnContext ctx) {
        Player player = ctx.m_43723_();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Level level = ctx.m_43725_();
        BlockPos pos = ctx.m_8083_();
        Direction side = ctx.m_43719_();
        BlockState state = level.m_8055_(pos);
        if (BaseFireBlock.m_49255_((Level)level, (BlockPos)pos, (Direction)side)) {
            if (!level.f_46443_ && PlayerHelper.hasBreakPermission((ServerPlayer)player, pos)) {
                level.m_46597_(pos, BaseFireBlock.m_49245_((BlockGetter)level, (BlockPos)pos));
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else if (CampfireBlock.m_51321_((BlockState)state)) {
            if (!level.f_46443_ && PlayerHelper.hasBreakPermission((ServerPlayer)player, pos)) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)BlockStateProperties.f_61443_, (Comparable)Boolean.valueOf(true)));
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else if (state.isFlammable((BlockGetter)level, pos, side)) {
            if (!level.f_46443_ && PlayerHelper.hasBreakPermission((ServerPlayer)player, pos)) {
                state.onCaughtFire(level, pos, side, (LivingEntity)player);
                if (state.m_60734_() instanceof TntBlock) {
                    level.m_7471_(pos, false);
                }
                level.m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), (SoundEvent)PESoundEvents.POWER.get(), SoundSource.PLAYERS, 1.0f, 1.0f);
            }
        } else {
            return InteractionResult.PASS;
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public static boolean isBlockLoaded(@Nullable BlockGetter world, @NotNull BlockPos pos) {
        if (world == null) {
            return false;
        }
        if (world instanceof LevelReader) {
            Level level;
            LevelReader reader = (LevelReader)world;
            if (reader instanceof Level && !(level = (Level)reader).m_46739_(pos)) {
                return false;
            }
            return reader.m_46805_(pos);
        }
        return true;
    }

    @Nullable
    public static BlockEntity getBlockEntity(@Nullable BlockGetter level, @NotNull BlockPos pos) {
        if (!WorldHelper.isBlockLoaded(level, pos)) {
            return null;
        }
        return level.m_7702_(pos);
    }

    @Nullable
    public static <BE extends BlockEntity> BE getBlockEntity(@NotNull Class<BE> clazz, @Nullable BlockGetter level, @NotNull BlockPos pos) {
        return WorldHelper.getBlockEntity(clazz, level, pos, false);
    }

    @Nullable
    public static <BE extends BlockEntity> BE getBlockEntity(@NotNull Class<BE> clazz, @Nullable BlockGetter level, @NotNull BlockPos pos, boolean logWrongType) {
        BlockEntity blockEntity = WorldHelper.getBlockEntity(level, pos);
        if (blockEntity == null) {
            return null;
        }
        if (clazz.isInstance(blockEntity)) {
            return (BE)((BlockEntity)clazz.cast(blockEntity));
        }
        if (logWrongType) {
            PECore.LOGGER.warn("Unexpected block entity class at {}, expected {}, but found: {}", new Object[]{pos, clazz, blockEntity.getClass()});
        }
        return null;
    }
}

