/*
 * Decompiled with CFR 0.152.
 */
package moze_intel.projecte.network;

import moze_intel.projecte.PECore;
import moze_intel.projecte.utils.text.PELang;
import moze_intel.projecte.utils.text.TextComponentUtil;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.ClickEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.VersionChecker;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.loading.FMLConfig;
import net.minecraftforge.forgespi.language.IModInfo;
import org.apache.maven.artifact.versioning.ComparableVersion;

@Mod.EventBusSubscriber(modid="projecte", value={Dist.CLIENT})
public class ThreadCheckUpdate
extends Thread {
    private static final String curseURL = "https://www.curseforge.com/minecraft/mc-mods/projecte/files";
    private static volatile ComparableVersion target = null;
    private static volatile boolean hasSentMessage = false;

    public ThreadCheckUpdate() {
        this.setName("ProjectE Update Checker Notifier");
    }

    @Override
    public void run() {
        if (!FMLConfig.getBoolConfigValue((FMLConfig.ConfigValue)FMLConfig.ConfigValue.VERSION_CHECK)) {
            return;
        }
        IModInfo info = PECore.MOD_CONTAINER.getModInfo();
        VersionChecker.CheckResult result = null;
        int tries = 0;
        do {
            VersionChecker.CheckResult res;
            if ((res = VersionChecker.getResult((IModInfo)info)).status() != VersionChecker.Status.PENDING) {
                result = res;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        } while (result == null && ++tries < 10);
        if (result == null) {
            PECore.LOGGER.info("Update check failed.");
            return;
        }
        if (result.status() == VersionChecker.Status.OUTDATED) {
            target = result.target();
        }
    }

    @SubscribeEvent
    public static void worldLoad(EntityJoinLevelEvent evt) {
        Entity entity = evt.getEntity();
        if (entity instanceof LocalPlayer) {
            LocalPlayer player = (LocalPlayer)entity;
            if (target != null && !hasSentMessage) {
                hasSentMessage = true;
                player.m_213846_((Component)PELang.UPDATE_AVAILABLE.translate(target));
                player.m_213846_((Component)PELang.UPDATE_GET_IT.translate(new Object[0]));
                player.m_213846_((Component)TextComponentUtil.build(new ClickEvent(ClickEvent.Action.OPEN_URL, curseURL), curseURL));
            }
        }
    }
}

