/*
 * Decompiled with CFR 0.152.
 */
package net.firemuffin303.thaidelight.common.recipe;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import net.firemuffin303.thaidelight.common.registry.ModRecipes;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.item.crafting.ShapedRecipe;
import net.minecraft.world.level.Level;

public class MortarRecipe
implements Recipe<Container> {
    private final ResourceLocation id;
    private final String group;
    private final NonNullList<Ingredient> ingredients;
    private final ItemStack result;

    public MortarRecipe(ResourceLocation id, String group, NonNullList<Ingredient> ingredients, ItemStack result) {
        this.id = id;
        this.group = group;
        this.ingredients = ingredients;
        this.result = result;
    }

    public ResourceLocation m_6423_() {
        return this.id;
    }

    public RecipeSerializer<?> m_7707_() {
        return ModRecipes.ModRecipeSerializer.MORTAR_SERIALIZER;
    }

    public String m_6076_() {
        return this.group;
    }

    public ItemStack m_8043_(RegistryAccess registryAccess) {
        return this.result;
    }

    public Ingredient getResult() {
        return Ingredient.m_43927_((ItemStack[])new ItemStack[]{this.result});
    }

    public NonNullList<Ingredient> m_7527_() {
        return this.ingredients;
    }

    public RecipeType<?> m_6671_() {
        return ModRecipes.MORTAR;
    }

    public boolean m_5818_(Container container, Level level) {
        StackedContents stackedContents = new StackedContents();
        int i = 0;
        for (int j = 0; j < container.m_6643_(); ++j) {
            ItemStack itemStack = container.m_8020_(j);
            if (itemStack.m_41619_()) continue;
            stackedContents.m_36468_(itemStack, 1);
            ++i;
        }
        return i == this.ingredients.size() && stackedContents.m_36475_((Recipe)this, null);
    }

    public ItemStack m_5874_(Container container, RegistryAccess registryAccess) {
        return this.m_8043_(registryAccess).m_41777_();
    }

    public boolean m_8004_(int i, int j) {
        return i * j >= this.ingredients.size();
    }

    public static class Serializer
    implements RecipeSerializer<MortarRecipe> {
        public MortarRecipe fromJson(ResourceLocation resourceLocation, JsonObject jsonObject) {
            String groupIn = GsonHelper.m_13851_((JsonObject)jsonObject, (String)"group", (String)"");
            NonNullList<Ingredient> inputItemsIn = Serializer.readIngredients(GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredients"));
            if (inputItemsIn.isEmpty()) {
                throw new JsonParseException("No ingredients for mortar recipe");
            }
            if (inputItemsIn.size() > 4) {
                throw new JsonParseException("Too many ingredients for mortar recipe. Maximum at 4");
            }
            ItemStack results = ShapedRecipe.m_151274_((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"));
            return new MortarRecipe(resourceLocation, groupIn, inputItemsIn, results);
        }

        private static NonNullList<Ingredient> readIngredients(JsonArray ingredientArray) {
            NonNullList nonnulllist = NonNullList.m_122779_();
            for (int i = 0; i < ingredientArray.size(); ++i) {
                Ingredient ingredient = Ingredient.m_288218_((JsonElement)ingredientArray.get(i), (boolean)false);
                if (ingredient.m_43947_()) continue;
                nonnulllist.add((Object)ingredient);
            }
            return nonnulllist;
        }

        public MortarRecipe fromNetwork(ResourceLocation resourceLocation, FriendlyByteBuf friendlyByteBuf) {
            String group = friendlyByteBuf.m_130277_();
            int i = friendlyByteBuf.m_130242_();
            NonNullList ingredients = NonNullList.m_122780_((int)i, (Object)Ingredient.f_43901_);
            for (int j = 0; j < ingredients.size(); ++j) {
                ingredients.set(j, (Object)Ingredient.m_43940_((FriendlyByteBuf)friendlyByteBuf));
            }
            ItemStack itemStack = friendlyByteBuf.m_130267_();
            return new MortarRecipe(resourceLocation, group, (NonNullList<Ingredient>)ingredients, itemStack);
        }

        public void toNetwork(FriendlyByteBuf friendlyByteBuf, MortarRecipe recipe) {
            friendlyByteBuf.m_130070_(recipe.group);
            friendlyByteBuf.m_130130_(recipe.ingredients.size());
            for (Ingredient ingredient : recipe.ingredients) {
                ingredient.m_43923_(friendlyByteBuf);
            }
            friendlyByteBuf.m_130055_(recipe.result);
        }
    }
}

