/*
 * Decompiled with CFR 0.152.
 */
package net.firemuffin303.thaidelight.common.entity;

import java.util.EnumSet;
import java.util.function.IntFunction;
import net.firemuffin303.thaidelight.common.entity.Bottleable;
import net.firemuffin303.thaidelight.common.registry.ModEntityTypes;
import net.firemuffin303.thaidelight.common.registry.ModItems;
import net.firemuffin303.thaidelight.common.registry.ModSoundEvents;
import net.firemuffin303.thaidelight.common.registry.ModTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.util.ByIdMap;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.AgeableMob;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.SpawnGroupData;
import net.minecraft.world.entity.VariantHolder;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.LookControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.goal.BreedGoal;
import net.minecraft.world.entity.ai.goal.FloatGoal;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.RandomLookAroundGoal;
import net.minecraft.world.entity.ai.goal.TemptGoal;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.AirAndWaterRandomPos;
import net.minecraft.world.entity.ai.util.HoverRandomPos;
import net.minecraft.world.entity.animal.Animal;
import net.minecraft.world.entity.animal.FlyingAnimal;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.GameRules;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.ServerLevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class Dragonfly
extends Animal
implements VariantHolder<DragonflyVariant>,
Bottleable,
FlyingAnimal {
    private static final Ingredient FOOD_ITEMS = Ingredient.m_204132_(ModTags.DRAGONFLY_FOOD);
    private static final EntityDataAccessor<Integer> DATA_VARIANT = SynchedEntityData.m_135353_(Dragonfly.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private static final EntityDataAccessor<Boolean> FROM_BOTTLE = SynchedEntityData.m_135353_(Dragonfly.class, (EntityDataSerializer)EntityDataSerializers.f_135035_);

    public Dragonfly(EntityType<? extends Animal> entityType, Level level) {
        super(entityType, level);
        this.f_21342_ = new DragonflyMoveControl(this);
        this.f_21365_ = new LookControl((Mob)this);
        this.m_21441_(BlockPathTypes.FENCE, -1.0f);
        this.m_21441_(BlockPathTypes.COCOA, -1.0f);
        this.m_21441_(BlockPathTypes.WATER, -1.0f);
        this.m_21441_(BlockPathTypes.LAVA, -1.0f);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Mob.m_21552_().m_22268_(Attributes.f_22276_, 4.0).m_22268_(Attributes.f_22280_, 0.650000023841858).m_22268_(Attributes.f_22279_, 0.40000001192092893).m_22268_(Attributes.f_22281_, 2.0);
    }

    protected PathNavigation m_6037_(Level level) {
        FlyingPathNavigation flyingPathNavigation = new FlyingPathNavigation((Mob)this, level){

            public boolean m_6342_(BlockPos blockPos) {
                return !this.f_26495_.m_8055_(blockPos.m_7495_()).m_60795_();
            }
        };
        flyingPathNavigation.m_26440_(false);
        flyingPathNavigation.m_7008_(false);
        flyingPathNavigation.m_26443_(true);
        return flyingPathNavigation;
    }

    @Nullable
    public AgeableMob m_142606_(ServerLevel serverLevel, AgeableMob ageableMob) {
        Dragonfly dragonfly = (Dragonfly)ModEntityTypes.DRAGONFLY.m_20615_((Level)serverLevel);
        if (dragonfly != null) {
            dragonfly.setVariant(this.f_19796_.m_188499_() ? this.getVariant() : ((Dragonfly)ageableMob).getVariant());
            dragonfly.m_21530_();
        }
        return dragonfly;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(DATA_VARIANT, (Object)0);
        this.f_19804_.m_135372_(FROM_BOTTLE, (Object)false);
    }

    protected void m_8099_() {
        this.f_21345_.m_25352_(0, (Goal)new FloatGoal((Mob)this));
        this.f_21345_.m_25352_(2, (Goal)new BreedGoal((Animal)this, 1.0));
        this.f_21345_.m_25352_(3, (Goal)new TemptGoal((PathfinderMob)this, 1.0, FOOD_ITEMS, false));
        this.f_21345_.m_25352_(7, (Goal)new RandomLookAroundGoal((Mob)this));
        this.f_21345_.m_25352_(8, (Goal)new DragonflyWanderGoal());
    }

    public InteractionResult m_6071_(Player player, InteractionHand interactionHand) {
        return Bottleable.tryBottle(player, interactionHand, this).orElse(super.m_6071_(player, interactionHand));
    }

    public float m_5610_(BlockPos blockPos, LevelReader levelReader) {
        return levelReader.m_8055_(blockPos).m_60795_() ? 10.0f : 0.0f;
    }

    public void m_7380_(CompoundTag compoundTag) {
        super.m_7380_(compoundTag);
        compoundTag.m_128405_("Variant", this.getVariant().getId());
        compoundTag.m_128379_("FromBottle", ((Boolean)this.f_19804_.m_135370_(FROM_BOTTLE)).booleanValue());
    }

    protected void m_30232_() {
        super.m_30232_();
        if (!this.m_6162_() && this.m_9236_().m_46469_().m_46207_(GameRules.f_46135_)) {
            this.m_20000_((ItemLike)Items.f_42714_, 1);
        }
    }

    public void m_7378_(CompoundTag compoundTag) {
        super.m_7378_(compoundTag);
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)compoundTag.m_128451_("Variant"));
        this.f_19804_.m_135381_(FROM_BOTTLE, (Object)compoundTag.m_128471_("FromBucket"));
    }

    protected void m_7840_(double d, boolean bl, BlockState blockState, BlockPos blockPos) {
    }

    public void setVariant(DragonflyVariant object) {
        this.f_19804_.m_135381_(DATA_VARIANT, (Object)object.getId());
    }

    public DragonflyVariant getVariant() {
        return DragonflyVariant.byId((Integer)this.f_19804_.m_135370_(DATA_VARIANT));
    }

    public MobType m_6336_() {
        return MobType.f_21642_;
    }

    protected void m_6138_() {
    }

    public boolean m_6094_() {
        return false;
    }

    protected void m_7324_(Entity entity) {
    }

    @Nullable
    protected SoundEvent m_7515_() {
        return null;
    }

    @Nullable
    protected SoundEvent m_7975_(DamageSource damageSource) {
        return ModSoundEvents.DRAGONFLY_HURT;
    }

    public boolean m_6898_(ItemStack itemStack) {
        return FOOD_ITEMS.test(itemStack);
    }

    @Override
    public boolean isFromBottle() {
        return (Boolean)this.f_19804_.m_135370_(FROM_BOTTLE);
    }

    @Override
    public void setFromBottle(boolean fromBottle) {
        this.f_19804_.m_135381_(FROM_BOTTLE, (Object)fromBottle);
    }

    @Override
    public void copyDataToStack(ItemStack stack) {
        Bottleable.copyDataToStack((Mob)this, stack);
        CompoundTag compoundTag = stack.m_41784_();
        compoundTag.m_128405_("Variant", this.getVariant().getId());
        compoundTag.m_128405_("Age", this.f_146733_);
    }

    @Override
    public void copyDataFromNbt(CompoundTag nbt) {
        Bottleable.copyDataFromNbt((Mob)this, nbt);
        this.setVariant(DragonflyVariant.byId(nbt.m_128451_("Variant")));
        this.m_146762_(nbt.m_128451_("Age"));
    }

    @Override
    public ItemStack getBottleItem() {
        return new ItemStack((ItemLike)ModItems.DRAGONFLY_BOTTLE);
    }

    @Override
    public SoundEvent getBottleFillSound() {
        return SoundEvents.f_11770_;
    }

    public boolean m_29443_() {
        return !this.m_20096_();
    }

    public boolean m_6147_() {
        return false;
    }

    public SpawnGroupData m_6518_(ServerLevelAccessor serverLevelAccessor, DifficultyInstance difficultyInstance, MobSpawnType mobSpawnType, @Nullable SpawnGroupData spawnGroupData, @Nullable CompoundTag compoundTag) {
        if (mobSpawnType == MobSpawnType.BUCKET) {
            return spawnGroupData;
        }
        RandomSource randomSource = serverLevelAccessor.m_213780_();
        this.setVariant(DragonflyVariant.byId(randomSource.m_216339_(0, 4)));
        return super.m_6518_(serverLevelAccessor, difficultyInstance, mobSpawnType, spawnGroupData, compoundTag);
    }

    static class DragonflyMoveControl
    extends MoveControl {
        private final Dragonfly dragonfly;

        public DragonflyMoveControl(Dragonfly mob) {
            super((Mob)mob);
            this.dragonfly = mob;
        }

        public void m_8126_() {
            if (this.f_24981_ == MoveControl.Operation.MOVE_TO) {
                this.f_24981_ = MoveControl.Operation.WAIT;
                this.f_24974_.m_20242_(true);
                double d = this.f_24975_ - this.f_24974_.m_20185_();
                double e = this.f_24976_ - this.f_24974_.m_20186_();
                double f = this.f_24977_ - this.f_24974_.m_20189_();
                double g = d * d + e * e + f * f;
                if (g < 2.500000277905201E-7) {
                    this.f_24974_.m_21567_(0.0f);
                    this.f_24974_.m_21564_(0.0f);
                    return;
                }
                float h = (float)(Mth.m_14136_((double)f, (double)d) * 57.2957763671875) - 90.0f;
                this.f_24974_.m_146922_(this.m_24991_(this.f_24974_.m_146908_(), h, 90.0f));
                float i = (float)this.f_24974_.m_21172_(Attributes.f_22280_);
                this.f_24974_.m_7910_(i);
                double j = Math.sqrt(d * d + f * f);
                if (Math.abs(e) > (double)1.0E-5f || Math.abs(j) > (double)1.0E-5f) {
                    float k = (float)(-(Mth.m_14136_((double)e, (double)j) * 57.2957763671875));
                    this.f_24974_.m_146926_(this.m_24991_(this.f_24974_.m_146909_(), k, 10.0f));
                    this.f_24974_.m_21567_(e > 0.0 ? i : -i);
                }
            } else {
                this.f_24974_.m_21567_(0.0f);
                this.f_24974_.m_21564_(0.0f);
            }
        }
    }

    public static enum DragonflyVariant {
        RED(0, "red", true),
        GREEN(1, "green", true),
        BLUE(2, "blue", true),
        YELLOW(3, "yellow", true);

        private final int id;
        private final String name;
        private final boolean common;
        private static final IntFunction<DragonflyVariant> BY_ID;

        private DragonflyVariant(int j, String string2, boolean bl) {
            this.id = j;
            this.name = string2;
            this.common = bl;
        }

        public String getName() {
            return this.name;
        }

        public int getId() {
            return this.id;
        }

        public static DragonflyVariant byId(int i) {
            return BY_ID.apply(i);
        }

        static {
            BY_ID = ByIdMap.m_262839_(DragonflyVariant::getId, (Object[])DragonflyVariant.values(), (ByIdMap.OutOfBoundsStrategy)ByIdMap.OutOfBoundsStrategy.ZERO);
        }
    }

    class DragonflyWanderGoal
    extends Goal {
        private static final int WANDER_THRESHOLD = 22;

        DragonflyWanderGoal() {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        }

        public boolean m_8036_() {
            return Dragonfly.this.f_21344_.m_26571_() && Dragonfly.this.f_19796_.m_188503_(10) == 0;
        }

        public boolean m_8045_() {
            return Dragonfly.this.f_21344_.m_26572_();
        }

        public void m_8056_() {
            Vec3 vec3 = this.findPos();
            if (vec3 != null) {
                Dragonfly.this.f_21344_.m_26536_(Dragonfly.this.f_21344_.m_7864_(BlockPos.m_274446_((Position)vec3), 1), 1.2);
            }
        }

        @Nullable
        private Vec3 findPos() {
            Vec3 vec32 = Dragonfly.this.m_20252_(0.0f);
            Vec3 vec33 = HoverRandomPos.m_148465_((PathfinderMob)Dragonfly.this, (int)8, (int)2, (double)vec32.f_82479_, (double)vec32.f_82481_, (float)1.5707964f, (int)3, (int)1);
            return vec33 != null ? vec33 : AirAndWaterRandomPos.m_148357_((PathfinderMob)Dragonfly.this, (int)8, (int)4, (int)-2, (double)vec32.f_82479_, (double)vec32.f_82481_, (double)1.5707963705062866);
        }
    }

    static class DragonflyLookGoal
    extends Goal {
        private final Dragonfly dragonfly;

        public DragonflyLookGoal(Dragonfly dragonfly) {
            this.dragonfly = dragonfly;
            this.m_7021_(EnumSet.of(Goal.Flag.LOOK));
        }

        public boolean m_8036_() {
            return true;
        }

        public void m_8037_() {
            if (this.dragonfly.m_5448_() == null) {
                Vec3 vec3 = this.dragonfly.m_20184_();
                this.dragonfly.m_146922_(-((float)Mth.m_14136_((double)vec3.f_82479_, (double)vec3.f_82481_)) * 57.295776f);
                this.dragonfly.f_20883_ = this.dragonfly.m_146908_();
            }
        }
    }

    static class FlyWanderGoal
    extends Goal {
        private final Dragonfly dragonfly;

        FlyWanderGoal(Dragonfly dragonfly) {
            this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
            this.dragonfly = dragonfly;
        }

        public boolean m_8036_() {
            double f;
            MoveControl moveControl = this.dragonfly.m_21566_();
            if (!moveControl.m_24995_()) {
                return true;
            }
            double d = moveControl.m_25000_() - this.dragonfly.m_20185_();
            double g = d * d + (f = moveControl.m_25002_() - this.dragonfly.m_20189_()) * f;
            return g < 1.0 || g > 1300.0;
        }

        public boolean m_8045_() {
            return false;
        }

        public void m_8056_() {
            RandomSource randomSource = this.dragonfly.m_217043_();
            double d = this.dragonfly.m_20185_() + (double)((randomSource.m_188501_() * 2.0f - 1.0f) * 3.0f);
            double e = this.dragonfly.m_20186_() + (double)(randomSource.m_188501_() * 2.0f - 1.0f);
            double f = this.dragonfly.m_20189_() + (double)((randomSource.m_188501_() * 2.0f - 1.0f) * 3.0f);
            this.dragonfly.f_21344_.m_26519_(d, e, f, 1.0);
        }
    }
}

