/*
 * Decompiled with CFR 0.152.
 */
package net.firemuffin303.thaidelight.common.block;

import net.firemuffin303.thaidelight.common.entity.FlowerCrabEntity;
import net.firemuffin303.thaidelight.common.registry.ModEntityTypes;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class CrabEggBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final BooleanProperty WATERLOGGED;
    private static int minHatchTickDelay;
    private static int maxHatchTickDelay;
    protected static final VoxelShape SHAPE;

    public CrabEggBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{WATERLOGGED});
    }

    public VoxelShape m_5940_(BlockState blockState, BlockGetter blockGetter, BlockPos blockPos, CollisionContext collisionContext) {
        return SHAPE;
    }

    public boolean m_7898_(BlockState blockState, LevelReader levelReader, BlockPos blockPos) {
        return CrabEggBlock.mayPlaceOn((BlockGetter)levelReader, blockPos.m_7495_());
    }

    public void m_6807_(BlockState blockState, Level level, BlockPos blockPos, BlockState blockState2, boolean bl) {
        level.m_186460_(blockPos, (Block)this, CrabEggBlock.getHatchDelay(level.m_213780_()));
    }

    private static int getHatchDelay(RandomSource randomSource) {
        return randomSource.m_216339_(minHatchTickDelay, maxHatchTickDelay);
    }

    public BlockState m_7417_(BlockState blockState, Direction direction, BlockState blockState2, LevelAccessor levelAccessor, BlockPos blockPos, BlockPos blockPos2) {
        if (((Boolean)blockState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            levelAccessor.m_186469_(blockPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)levelAccessor));
        }
        return !this.m_7898_(blockState, (LevelReader)levelAccessor, blockPos) ? Blocks.f_50016_.m_49966_() : super.m_7417_(blockState, direction, blockState2, levelAccessor, blockPos, blockPos2);
    }

    public void m_213897_(BlockState blockState, ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        if (!this.m_7898_(blockState, (LevelReader)serverLevel, blockPos)) {
            this.destroyBlock((Level)serverLevel, blockPos);
        } else {
            this.hatchFrogspawn(serverLevel, blockPos, randomSource);
        }
    }

    public void m_7892_(BlockState blockState, Level level, BlockPos blockPos, Entity entity) {
        if (entity.m_6095_().equals(EntityType.f_20450_)) {
            this.destroyBlock(level, blockPos);
        }
    }

    private static boolean mayPlaceOn(BlockGetter blockGetter, BlockPos blockPos) {
        FluidState fluidState = blockGetter.m_6425_(blockPos);
        FluidState fluidState2 = blockGetter.m_6425_(blockPos.m_7494_());
        return fluidState2.m_76152_() == Fluids.f_76193_;
    }

    private void hatchFrogspawn(ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        this.destroyBlock((Level)serverLevel, blockPos);
        serverLevel.m_5594_((Player)null, blockPos, SoundEvents.f_215687_, SoundSource.BLOCKS, 1.0f, 1.0f);
        this.spawnCrabs(serverLevel, blockPos, randomSource);
    }

    private void destroyBlock(Level level, BlockPos blockPos) {
        level.m_46961_(blockPos, false);
    }

    private void spawnCrabs(ServerLevel serverLevel, BlockPos blockPos, RandomSource randomSource) {
        int i = randomSource.m_216339_(2, 6);
        for (int j = 0; j <= i; ++j) {
            FlowerCrabEntity crabEntity = (FlowerCrabEntity)ModEntityTypes.FLOWER_CRAB.m_20615_((Level)serverLevel);
            if (crabEntity == null) continue;
            double d = (double)blockPos.m_123341_() + this.getRandomPositionOffset(randomSource);
            double e = (double)blockPos.m_123343_() + this.getRandomPositionOffset(randomSource);
            int k = randomSource.m_216339_(1, 361);
            crabEntity.m_7678_(d, blockPos.m_123342_(), e, k, 0.0f);
            crabEntity.m_6863_(true);
            crabEntity.m_21530_();
            serverLevel.m_7967_((Entity)crabEntity);
        }
    }

    private double getRandomPositionOffset(RandomSource randomSource) {
        double d = 0.4f;
        return Mth.m_14008_((double)randomSource.m_188500_(), (double)d, (double)(1.0 - d));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext blockPlaceContext) {
        Level levelAccessor = blockPlaceContext.m_43725_();
        BlockPos blockPos = blockPlaceContext.m_8083_();
        return (BlockState)this.m_49966_().m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(levelAccessor.m_6425_(blockPos).m_76152_() == Fluids.f_76193_));
    }

    public FluidState m_5888_(BlockState blockState) {
        return (Boolean)blockState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(blockState);
    }

    static {
        minHatchTickDelay = 3600;
        maxHatchTickDelay = 12000;
        SHAPE = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.5, (double)16.0);
        WATERLOGGED = BlockStateProperties.f_61362_;
    }
}

